/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.model.msg.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.integrate.model.msg.BaseMessage;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextMessage
extends BaseMessage {
    private static final Log logger = LogFactory.getLog(TextMessage.class);
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    private MsgContent text;

    public TextMessage() {
    }

    public TextMessage(String toUser, String toParty, String msg) {
        super.setTouser(toUser);
        super.setToparty(toParty);
        this.setText(msg);
    }

    @Override
    public String getMsgtype() {
        return "text";
    }

    @Override
    public String getAgentid() {
        if (StringUtil.isEmpty((String)this.agentid)) {
            this.agentid = this.systemConfigFeignService.getPropertyByAlias("agentid");
        }
        return this.agentid;
    }

    public MsgContent getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = new MsgContent(text);
    }

    public String toString() {
        String msgStr = "";
        try {
            msgStr = JsonUtil.toJson((Object)this);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return msgStr;
    }

    public static void main(String[] args) {
        TextMessage message = new TextMessage("zyg", "", "hello zyg");
        message.setAgentid("1");
        System.out.println(message);
    }

    class MsgContent {
        private String content;

        public MsgContent(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

