/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IOrgService;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysIndexColumn/sysIndexColumn/v1/"})
@Api(tags={"\u95e8\u6237\u680f\u76ee"})
@ApiGroup(group={"group_system"})
public class SysIndexColumnController
extends BaseController<SysIndexColumnManager, SysIndexColumn> {
    @Resource
    SysIndexColumnManager sysIndexColumnService;
    @Resource
    IOrgService sysOrgService;
    @Resource
    IUserService ius;
    @Resource
    IUserGroupService ig;
    @Resource
    BaseContext baseContext;
    @Resource
    MultiTenantHandler multiTenantHandler;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Value(value="${system.saas.enable:false}")
    Boolean saasEnable;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysIndexColumn> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexColumn> queryFilter) throws Exception {
        return this.sysIndexColumnService.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysIndexColumn getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (BeanUtils.isEmpty((Object)id)) {
            return null;
        }
        return (SysIndexColumn)this.sysIndexColumnService.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysIndexColumn getByAlias(@ApiParam(name="alias", value="\u4e3b\u952e", required=true) @RequestParam String alias) throws Exception {
        if (BeanUtils.isEmpty((Object)alias)) {
            return null;
        }
        return this.sysIndexColumnService.getByColumnAlias(alias);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.sysIndexColumnService.removeByIds(aryIds);
            return new CommonResult(true, ThreadMsgUtil.getMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5220\u9664\u680f\u76ee\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u66f4\u65b0\u9996\u9875\u680f\u76ee", httpMethod="POST", notes="\u6dfb\u52a0\u6216\u66f4\u65b0\u9996\u9875\u680f\u76ee")
    public CommonResult<String> save(@ApiParam(name="sysIndexColumn", value="\u9996\u9875\u680f\u76ee") @RequestBody SysIndexColumn sysIndexColumn) throws Exception {
        String message = null;
        try {
            String orgId;
            String alias = sysIndexColumn.getAlias();
            Boolean isExist = this.sysIndexColumnService.isExistAlias(sysIndexColumn.getAlias(), sysIndexColumn.getId());
            if (isExist.booleanValue()) {
                message = "\u680f\u76ee\u522b\u540d\uff1a[" + alias + "]\u5df2\u5b58\u5728";
                return new CommonResult(false, message, null);
            }
            if (!ContextUtil.getCurrentUser().isAdmin() && BeanUtils.isNotEmpty((Object)(orgId = ((IGroup)this.ig.getGroupsByUserIdOrAccount(ContextUtil.getCurrentUserId()).get(0)).getGroupId()))) {
                sysIndexColumn.setOrgId(orgId);
            }
            if (StringUtil.isZeroEmpty((String)sysIndexColumn.getId())) {
                sysIndexColumn.setId(UniqueIdUtil.getSuid());
                sysIndexColumn.setCreateTime(LocalDateTime.now());
                this.sysIndexColumnService.createAndAuth(sysIndexColumn);
                message = "\u6dfb\u52a0\u9996\u9875\u680f\u76ee\u6210\u529f";
            } else {
                sysIndexColumn.setUpdateTime(LocalDateTime.now());
                this.sysIndexColumnService.update((Model)sysIndexColumn);
                message = "\u66f4\u65b0\u9996\u9875\u680f\u76ee\u6210\u529f";
            }
            return new CommonResult(true, message, null);
        }
        catch (Exception e) {
            return new CommonResult(false, message + "," + e.getMessage(), null);
        }
    }

    @RequestMapping(value={"getTemp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9884\u89c8\u6a21\u7248", httpMethod="POST", notes="\u9884\u89c8\u6a21\u7248")
    public String getTemp(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        String html = "";
        SysIndexColumn sysIndexColumn = (SysIndexColumn)this.sysIndexColumnService.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexColumn))) {
            html = "<div template-alias=\"" + sysIndexColumn.getAlias() + "\"></div>";
        }
        return JsonUtil.toJson((Object)html);
    }

    @RequestMapping(value={"getData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6")
    public String getData(@ApiParam(name="alias", value="\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="params", value="\u53c2\u6570", required=true) @RequestParam String params) throws Exception {
        Map<String, Object> param = this.getParameterValueMap(params);
        String data = "";
        try {
            data = this.sysIndexColumnService.getHtmlByColumnAlias(alias, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @RequestMapping(value={"parseByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6")
    public String parseByAlias(@ApiParam(name="alias", value="\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="params", value="\u53c2\u6570", required=true) @RequestParam String params) throws Exception {
        Map<String, Object> param = this.getParameterValueMap(params);
        String data = "";
        try {
            data = this.sysIndexColumnService.getHtmlByColumnAlias(alias, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    @RequestMapping(value={"getDatasByAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6\uff08\u6839\u636e\u522b\u540d\u6279\u91cf\u83b7\u53d6\uff09", httpMethod="POST", notes="\u53d6\u5f97\u9996\u9875\u680f\u76ee\u660e\u7ec6\uff08\u6839\u636e\u522b\u540d\u6279\u91cf\u83b7\u53d6\uff09")
    public List<SysIndexColumn> getDatasByAlias(@ApiParam(name="alias", value="\u522b\u540d(\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00)", required=true) @RequestBody String alias) throws Exception {
        return ((SysIndexColumnManager)this.baseService).batchGetColumnAliases(alias);
    }

    private Map<String, Object> getParameterValueMap(String params) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)params)) {
            return map;
        }
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)params);
        Iterator it = node.fields();
        while (it.hasNext()) {
            String key = (String)it.next();
            JsonNode value = node.get(key);
            map.put(key, value);
        }
        return map;
    }

    @GetMapping(value={"validateProcAnn"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u5224\u65ad\u8be5\u6d41\u7a0b\u516c\u793a\u5217\u8868\u80fd\u5426\u8bbf\u95ee", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49key\u5224\u65ad\u8be5\u6d41\u7a0b\u516c\u793a\u5217\u8868\u80fd\u5426\u8bbf\u95ee")
    public CommonResult validateProcAnn(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key") @RequestParam String defKey) throws Exception {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"COL_TYPE", (Object)2);
        qw.eq((Object)"is_public", (Object)2);
        qw.eq((Object)"col_url", (Object)("/completeView/" + defKey));
        List sysIndexColumns = ((SysIndexColumnManager)this.baseService).getBaseMapper().selectList((Wrapper)qw);
        if (BeanUtils.isEmpty((Object)sysIndexColumns)) {
            return new CommonResult(false, "\u8be5\u6d41\u7a0b\u672a\u914d\u7f6e\u6d41\u7a0b\u516c\u793a");
        }
        for (SysIndexColumn column : sysIndexColumns) {
            if (!this.sysAuthUserManager.hasRights(column.getId())) continue;
            return new CommonResult(true, "");
        }
        return new CommonResult(false, "\u60a8\u65e0\u6743\u67e5\u770b\u8be5\u6d41\u7a0b\u7684\u6d41\u7a0b\u516c\u793a");
    }

    @PostMapping(value={"exportColumn"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u95e8\u6237\u680f\u76ee", httpMethod="POST", notes="\u6839\u636eid\u96c6\u5408\u5bfc\u51fa\u95e8\u6237\u680f\u76ee")
    public void exportColumn(@ApiParam(name="ids", value="id\u96c6\u5408") @RequestBody List<String> ids, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = "indexColumn_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        String json = ((SysIndexColumnManager)this.baseService).exportColumn(ids);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"indexColumns.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"importColumn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u680f\u76ee", httpMethod="POST", notes="\u5bfc\u5165\u680f\u76ee")
    public CommonResult importColumn(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile file = request.getFile("file");
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            ((SysIndexColumnManager)this.baseService).importFile(uzPath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
    }
}

