/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.dao.DataDictDao;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.DataDict;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.sysConfig.vo.DataDictDatalExcelVo;
import com.artfess.sysConfig.vo.DataDictExcelVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="dataDictManager")
public class DataDictManagerImpl
extends BaseManagerImpl<DataDictDao, DataDict>
implements DataDictManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    IdGenerator idGenerator;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    BaseContext baseContext;

    @Override
    public List<DataDict> getAllDataVal() throws Exception {
        String tenantId = this.baseContext.getCurrentTenantId();
        List list = this.redisUtil.lGet("sys:dimension:dict:" + tenantId, 0L, -1L);
        ArrayList<DataDict> relist = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            relist = ((DataDictDao)this.baseMapper).getAllDataVal();
            this.redisUtil.lSet("sys:dimension:dict:" + tenantId, relist);
            return relist;
        }
        ArrayList sslist = (ArrayList)list.get(0);
        relist = sslist.stream().map(obj -> (DataDict)((Object)((Object)obj))).collect(Collectors.toList());
        return relist;
    }

    @Override
    public List<DataDict> getByTypeId(String typeId) {
        return ((DataDictDao)this.baseMapper).getByTypeId(typeId);
    }

    @Override
    public List<DataDict> getDicByTypeId(String type_id_) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"type_id_", (Object)type_id_);
        queryWrapper.eq((Object)"type_", (Object)"dic");
        queryWrapper.orderByAsc((Object)"sn_");
        return ((DataDictDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DataDict> getDicByDicId(String dicId, boolean isDic) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dic_id_", (Object)dicId);
        if (!isDic) {
            queryWrapper.eq((Object)"type_", (Object)"val");
        }
        queryWrapper.orderByAsc((Object)"sn_");
        return ((DataDictDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<DataDict> getByDicKey(String dicKey) {
        Assert.hasText((String)dicKey, (String)"\u5b57\u5178\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((DataDictDao)this.baseMapper).getByDicKey(dicKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean moveDic(List<String> ids, String gId, String type) {
        Assert.hasText((String)gId, (String)"\u76ee\u6807ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)type, (String)"\u79fb\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(ids)) {
            throw new ApplicationException("\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u5b57\u5178\u9879\uff01");
        }
        String tenantId = this.baseContext.getCurrentTenantId();
        this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("dic")) {
            ((UpdateWrapper)updateWrapper.set((Object)"type_id_", (Object)gId)).in((Object)"dic_id_", ids);
            UpdateWrapper dictUpdateWrapper = new UpdateWrapper();
            ((UpdateWrapper)dictUpdateWrapper.set((Object)"parent_id_", (Object)gId)).in((Object)"id_", ids);
            this.update((Wrapper)dictUpdateWrapper);
            return this.update((Wrapper)updateWrapper);
        }
        if (type.equals("val")) {
            DataDict parentDic = (DataDict)((Object)this.getById((Serializable)((Object)gId)));
            if (parentDic == null) {
                throw new ApplicationException("\u6ca1\u6709\u627e\u5230\u8981\u79fb\u52a8\u5230\u7684\u5b57\u5178\u9879\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"parent_id_", (Object)gId)).set((Object)"type_id_", (Object)parentDic.getTypeId())).set((Object)"dic_id_", (Object)parentDic.getDicId())).in((Object)"id_", ids);
            return this.update((Wrapper)updateWrapper);
        }
        return false;
    }

    @Override
    public DataDict getByKey(String type, String key, String dicId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtil.isNotEmpty((String)dicId), (Object)"dic_id_", (Object)dicId);
        queryWrapper.eq((Object)"type_", (Object)type);
        queryWrapper.eq((Object)"key_", (Object)key);
        List list = ((DataDictDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (DataDict)((Object)list.get(0));
    }

    @Override
    public DataDict getByDictKey(String typeId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId);
        params.put("key", key);
        return ((DataDictDao)this.baseMapper).getByDictKey(params);
    }

    public void removeByIds(String ... ids) {
        String tenantId = this.baseContext.getCurrentTenantId();
        this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
        if (BeanUtils.isNotEmpty((Object)ids)) {
            for (String id : ids) {
                this.remove((Serializable)((Object)id));
                List<DataDict> childs = this.getChildrenByParentId(id);
                for (DataDict dict : childs) {
                    this.remove((Serializable)((Object)dict.getId()));
                }
            }
        }
        super.removeByIds(ids);
    }

    @Override
    public List<DataDict> getFirstChilsByParentId(String id) {
        return ((DataDictDao)this.baseMapper).getByParentId(id);
    }

    @Override
    public List<DataDict> getChildrenByParentId(String id) {
        List<DataDict> childs = ((DataDictDao)this.baseMapper).getByParentId(id);
        return this.getChilds(childs);
    }

    private List<DataDict> getChilds(List<DataDict> childs) {
        ArrayList<DataDict> dataDict = new ArrayList<DataDict>();
        if (BeanUtils.isNotEmpty(childs)) {
            for (DataDict dict : childs) {
                List<DataDict> children = ((DataDictDao)this.baseMapper).getByParentId(dict.getId());
                if (!BeanUtils.isNotEmpty(children)) continue;
                children = this.getChilds(children);
                dataDict.addAll(children);
            }
            dataDict.addAll(childs);
        }
        return dataDict;
    }

    @Override
    public void delByDictTypeId(String dictTypeId) {
        String tenantId = this.baseContext.getCurrentTenantId();
        this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
        ((DataDictDao)this.baseMapper).delByDictTypeId(dictTypeId);
    }

    @Override
    public void updSn(String dicId, int sn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", dicId);
        params.put("sn", sn);
        ((DataDictDao)this.baseMapper).updSn(params);
    }

    @Override
    public CommonResult<String> removeByTypeIds(String typeIds) {
        if (StringUtil.isNotEmpty((String)typeIds)) {
            List<SysType> typeList = this.sysTypeManager.getChildByTypeId(typeIds);
            String[] typeIdList = new String[typeList.size() + 1];
            typeIdList[0] = typeIds;
            for (int i = 0; i < typeList.size(); ++i) {
                typeIdList[i + 1] = typeList.get(i).getId();
            }
            this.sysTypeManager.removeByIds(typeIdList);
            for (String typeId : typeIdList) {
                ((DataDictDao)this.baseMapper).delByDictTypeId(typeId);
            }
            String tenantId = this.baseContext.getCurrentTenantId();
            this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
        }
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    @Transactional
    public void importData(List<MultipartFile> files, String typeId) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        HashMap<String, DataDict> data = new HashMap<String, DataDict>();
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            throw new BaseException("\u8bf7\u9009\u62e9\u6570\u636e\u5b57\u5178\u5206\u7c7b\u8fdb\u884c\u5bfc\u5165");
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List list = ExcelUtil.readExcel(DataDictDatalExcelVo.class, (MultipartFile)file);
            LinkedList<DataDict> dataDictBuffer = new LinkedList<DataDict>();
            for (DataDictDatalExcelVo vo : list) {
                String pKey = vo.getPidKey();
                String key = vo.getKey();
                String name = vo.getName();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("typeId", typeId);
                params.put("key", key);
                DataDict dict = ((DataDictDao)this.baseMapper).getByDictKey(params);
                if (dict != null) {
                    throw new BaseException("\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                DataDict dataDict = new DataDict();
                dataDict.setTypeId(typeId);
                if (StringUtil.isEmpty((String)pKey)) {
                    dataDict.setParentId(typeId);
                } else {
                    HashMap<String, Object> pMap = new HashMap<String, Object>();
                    pMap.put("typeId", typeId);
                    pMap.put("key", pKey);
                    DataDict dtDict = ((DataDictDao)this.baseMapper).getByDictKey(pMap);
                    if (BeanUtils.isEmpty((Object)((Object)dtDict))) {
                        DataDict dmDict = (DataDict)((Object)data.get(pKey));
                        if (BeanUtils.isEmpty((Object)((Object)dmDict))) {
                            if (this.isParentKeyInList(pKey, list)) {
                                dataDict.setParentId(pKey);
                                dataDict.setKey(key);
                                dataDict.setName(name);
                                dataDictBuffer.add(dataDict);
                                continue;
                            }
                            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7236\u8282\u70b9key");
                        }
                        dataDict.setParentId(dmDict.getId());
                    }
                    dataDict.setParentId(dtDict.getId());
                }
                dataDict.setKey(key);
                dataDict.setName(name);
                this.create((Model)dataDict);
                data.put(key, dataDict);
            }
            this.handleSaveBuffer(dataDictBuffer, data);
        }
        String tenantId = this.baseContext.getCurrentTenantId();
        this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
    }

    @Override
    @Transactional
    public void importDic(MultipartFile file) throws Exception {
        List list = ExcelUtil.readExcel(DataDictExcelVo.class, (MultipartFile)file);
        ArrayList<DataDict> saveList = new ArrayList<DataDict>();
        for (DataDictExcelVo vo : list) {
            DataDict dict;
            String typeCode = vo.getTypeCode();
            SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("dic", typeCode);
            if (sysType == null || (dict = this.getByKey("dic", vo.getKey(), "")) != null) continue;
            DataDict dataDict = new DataDict();
            dataDict.setId(this.idGenerator.getSuid());
            dataDict.setKey(vo.getKey());
            dataDict.setName(vo.getName());
            dataDict.setType("dic");
            dataDict.setTypeId(sysType.getId());
            dataDict.setParentId(sysType.getId());
            dataDict.setDicId(dataDict.getId());
            dataDict.setSn(Integer.valueOf(vo.getSn()));
            saveList.add(dataDict);
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.saveBatch(saveList);
            String tenantId = this.baseContext.getCurrentTenantId();
            this.redisUtil.del(new String[]{"sys:dimension:dict:" + tenantId});
        }
    }

    private boolean isParentKeyInList(String parentKey, List<DataDictDatalExcelVo> list) {
        if (StringUtil.isEmpty((String)parentKey) || BeanUtils.isEmpty(list)) {
            return false;
        }
        for (DataDictDatalExcelVo dataDictDatalExcelVo : list) {
            if (!parentKey.equals(dataDictDatalExcelVo.getPidKey())) continue;
            return true;
        }
        return false;
    }

    private void handleSaveBuffer(LinkedList<DataDict> list, Map<String, DataDict> data) {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        int count = 0;
        while (list.size() > 0) {
            DataDict dataDict = list.removeFirst();
            String parentKey = dataDict.getParentId();
            DataDict parent = data.get(parentKey);
            if (BeanUtils.isEmpty((Object)((Object)parent))) {
                list.addLast(dataDict);
                if (++count <= size) continue;
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e");
            }
            dataDict.setParentId(parent.getId());
            this.create((Model)dataDict);
            data.put(dataDict.getKey(), dataDict);
            size = list.size();
            count = 0;
        }
    }
}

