package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  产品销售数据类型
 */
@Getter
public enum ProductSalesDataTypeEnum {
    /**
     *
     */
    ONE("1", "密封条"),

    TWO("2", "胶料"),

    THREE("3", "建筑"),

    FOUR("4", "工业"),

    FIVE("5", "非汽车"),

    ;

    ProductSalesDataTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        ProductSalesDataTypeEnum[] values = values();
        for (ProductSalesDataTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        ProductSalesDataTypeEnum[] values = values();
        for (ProductSalesDataTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
