package com.artfess.base.vo;



import com.artfess.base.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户设备信息
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author pangquan
 * @email pangq@jee-soft.cn
 * @date 2020年07月30日
 */
@ApiModel(value = "ClientInfo", description = "用户设备信息")
public class ClientInfo {
	@ApiModelProperty(value = "账号")
	private String account;
	/**
	 * 推送服务令牌（设备唯一标识），用于标识推送信息接收者身份
	 * 
	 * 第三方推送服务器管理的设备唯一标识，在iOS平台此值通常与token不同；在其它平台此值通常与token值一致。
	 * 此值与设备及应用都相关，即不同的apk/ipa安装到同一台设备上的值都不相同。
	 */
	@ApiModelProperty(value = "设备唯一标识")
	private String clientId;
	/**
	 * 设备令牌（iOS设备唯一标识），用于APNS服务推送中标识设备的身份
	 */
	@ApiModelProperty(value = "设备令牌（iOS设备唯一标识）")
	private String clientToken;

	public ClientInfo() {
		super();
	}

	public ClientInfo(String clientId, String clientToken) {
		super();
		this.clientId = clientId;
		this.clientToken = clientToken;
	}

	public ClientInfo(String account, String clientId, String clientToken) {
		super();
		this.account = account;
		this.clientId = clientId;
		this.clientToken = clientToken;
	}

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getClientId() {
		return clientId;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public String getClientToken() {
		return clientToken;
	}

	public void setClientToken(String clientToken) {
		this.clientToken = clientToken;
	}
	public boolean clientIdEqClientToken(){
		if(StringUtil.isNotEmpty(clientId) && clientId.equals(clientToken) ){
			return true;
		}
		return false;
	}
}
