/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComputeWorkingDayUtil {
    private static List<String> HOLIDAY_LIST = new ArrayList<String>();
    private static List<String> SPECIAL_WORKDAY_LIST = new ArrayList<String>();

    public static int computeWorkingDays(Date start, Date end) {
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(start);
        endCal.setTime(end);
        int workDays = 0;
        if (startCal.getTimeInMillis() > endCal.getTimeInMillis()) {
            startCal.setTime(end);
            endCal.setTime(start);
        }
        while (startCal.getTimeInMillis() <= endCal.getTimeInMillis()) {
            System.out.println(DateUtil.format((Date)startCal.getTime(), (String)"yyyy-MM-dd") + "   " + DateUtil.format((Date)endCal.getTime(), (String)"yyyy-MM-dd"));
            String current = DateUtil.format((Date)startCal.getTime(), (String)"yyyy-MM-dd");
            int dayOfWeek = startCal.get(7);
            if (dayOfWeek != 7 && dayOfWeek != 1 && !HOLIDAY_LIST.contains(current)) {
                System.out.println(true);
                ++workDays;
            }
            if (SPECIAL_WORKDAY_LIST.contains(current)) {
                System.out.println(true);
                ++workDays;
            }
            startCal.add(5, 1);
        }
        return workDays;
    }

    public static void main(String[] args) {
        ComputeWorkingDayUtil.computeWorkingDays(new Date(), new Date());
    }

    static {
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("key", "b9bd81f0d27995863f2104a68259a02a");
                this.put("type", 1);
            }
        };
        int currentYear = Calendar.getInstance().get(1);
        for (int i = 0; i < 3; ++i) {
            param.put("date", currentYear - i);
            String url = "http://api.tianapi.com/jiejiari/index";
            String response = HttpUtil.get((String)url, (Map)param);
            JSONObject resObj = JSONUtil.parseObj((String)response);
            int code = (Integer)resObj.get((Object)"code");
            if (code != 200) continue;
            JSONArray newslist = (JSONArray)resObj.get((Object)"newslist");
            for (Object listObj : newslist) {
                JSONObject obj = (JSONObject)listObj;
                String holidays = (String)obj.get((Object)"vacation");
                String[] holidayArray = holidays.split("\\|");
                HOLIDAY_LIST.addAll(Arrays.asList(holidayArray));
                String remark = (String)obj.get((Object)"remark");
                if (!StringUtil.isNotEmpty((String)remark)) continue;
                String[] special = remark.split("\\|");
                SPECIAL_WORKDAY_LIST.addAll(Arrays.asList(special));
            }
        }
        System.out.println("=============SPECIAL_WORKDAY_LIST==========" + SPECIAL_WORKDAY_LIST);
    }
}

