/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rocketmq.producer;

import com.artfess.rocketmq.model.MessageBody;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class RocketMQUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMQUtil.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    private void sendMsg(MSG_TYPE msg_type, final String topic, Object payload, String msgSource) {
        String msgId = UUID.randomUUID().toString().replace("-", "");
        MessageBody msgBody = new MessageBody(msgId, payload, msgSource);
        Message message = MessageBuilder.withPayload((Object)msgBody).setHeader("KEYS", (Object)msgId).build();
        log.info(String.format("\u6d88\u606f\u53d1\u9001 MQService \u5f00\u59cb: %s %s", topic, message));
        SendResult result = null;
        switch (msg_type) {
            case ONEWAY: {
                this.rocketMQTemplate.sendOneWay(topic, message);
                break;
            }
            case ASYNC: {
                this.rocketMQTemplate.asyncSend(topic, message, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(Throwable throwable) {
                        log.error("MQService:" + ExceptionUtils.getStackTrace((Throwable)throwable));
                        throw new RuntimeException(String.format("\u6d88\u606f\u53d1\u9001\u5931\u8d25 topic_tag:%s", topic));
                    }
                });
                break;
            }
            case SYNC: {
                result = this.rocketMQTemplate.syncSend(topic, message);
            }
        }
        log.info(String.format("\u6d88\u606f\u53d1\u9001 MQService \u7ed3\u675f: msgId: %s dest: %s msg: %s", result != null ? result.getMsgId() : "", topic, message));
    }

    public void syncSendMsg(String topic, Object payload, String msgSource) {
        this.sendMsg(MSG_TYPE.SYNC, topic, payload, msgSource);
    }

    public void syncSendMsg(String topic, String tag, Object payload, String msgSource) {
        String destination = topic + ":" + tag;
        this.syncSendMsg(destination, payload, msgSource);
    }

    public void asyncSendMsg(String topic, Object payload, String msgSource) {
        this.sendMsg(MSG_TYPE.ASYNC, topic, payload, msgSource);
    }

    public void asyncSendMsg(String topic, String tag, Object payload, String msgSource) {
        String destination = topic + ":" + tag;
        this.asyncSendMsg(destination, payload, msgSource);
    }

    public void oneWaySendMsg(String topic, Object payload, String msgSource) {
        this.sendMsg(MSG_TYPE.ONEWAY, topic, payload, msgSource);
    }

    public void oneWaySendMsg(String topic, String tag, Object payload, String msgSource) {
        String destination = topic + ":" + tag;
        this.oneWaySendMsg(destination, payload, msgSource);
    }

    private static enum MSG_TYPE {
        ONEWAY,
        ASYNC,
        SYNC;

    }
}

