package com.artfess.manage.safty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 安全年度工作计划表(CmgtSaftyPlan)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-04 13:49:27
 */
@Data
@TableName("CMGT_SAFTY_PLAN")
@ApiModel("安全年度工作计划表(CmgtSaftyPlan)表实体类")
public class CmgtSaftyPlan extends AutoFillModel<CmgtSaftyPlan> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "必须指定 工作目标ID", groups = {AddGroup.class, UpdateGroup.class})
    @TableField("target_id_")
    @ApiModelProperty("工作目标_ID")
    private String targetId;

    @TableField("plan_year_")
    @ApiModelProperty("任务计划年度")
    private String planYear;

    @TableField("safty_class_")
    @ApiModelProperty("安全业务分类（参考字典 aqywlb）")
    private String saftyClass;

    @TableField("plan_name_")
    @ApiModelProperty("任务计划名称")
    private String planName;

    @TableField("plan_description_")
    @ApiModelProperty("任务计划工作内容描述")
    private String planDescription;

    @TableField("plan_start_date_")
    @ApiModelProperty("任务执行-开始日期")
    private LocalDate planStartDate;

    @TableField("plan_end_date_")
    @ApiModelProperty("任务执行-结束日期")
    private LocalDate planEndDate;

    @TableField("plan_complete")
    @ApiModelProperty("任务完成时限说明")
    private String planComplet;

    @TableField("duty_org_")
    @ApiModelProperty("牵头责任部门")
    private String dutyOrg;

    @ApiModelProperty("责任人")
    @TableField("duty_user_")
    private String dutyUser;

    @ApiModelProperty("任务依据")
    @TableField("according_")
    private String according;

    @ApiModelProperty("排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty("备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
