package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingRecordDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingRecordDetailDao;
import com.artfess.manage.safty.manager.CmgtSaftyTrainingRecordDetailManager;
import com.artfess.manage.safty.manager.CmgtSaftyTrainingRecordManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyTrainingRecordDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyTrainingRecordDetailDtoMapper;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyTrainingRecordDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyTrainingRecord;
import com.artfess.manage.safty.model.CmgtSaftyTrainingRecordDetail;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 安全培训记录 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyTrainingRecordManagerImpl extends BaseManagerImpl<CmgtSaftyTrainingRecordDao, CmgtSaftyTrainingRecord> implements CmgtSaftyTrainingRecordManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyTrainingRecordDao cmgtSaftyTrainingRecordDao;

    @Resource
    private CmgtSaftyTrainingRecordDtoMapper cmgtSaftyTrainingRecordDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;

    @Resource
    private CmgtSaftyTrainingRecordDetailDao cmgtSaftyTrainingRecordDetailDao;

    @Resource
    private CmgtSaftyTrainingRecordDetailDtoMapper cmgtSaftyTrainingRecordDetailDtoMapper;

    @Resource
    private CmgtSaftyTrainingRecordDetailManager cmgtSaftyTrainingRecordDetailManager;

    @Override
    public PageList<CmgtSaftyTrainingRecordDto> pageQuery(QueryFilter<CmgtSaftyTrainingRecord> queryFilter) {
        PageList<CmgtSaftyTrainingRecord> result = query(queryFilter);
        PageList<CmgtSaftyTrainingRecordDto> r = new PageList<CmgtSaftyTrainingRecordDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyTrainingRecordDto t = cmgtSaftyTrainingRecordDtoMapper.toDto(e);
                                    t.setTrainingProjectIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTrainingProjects","id","name",t.getTrainingProjectId()));
                                    t.setTeacherName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getUsers","fullname","fullname",t.getTeacher()));
                                    t.setTrainingPlanIdName(manageCommonService.getfindSelectOptionsLabel("cmgtSaftySelectOptions.getCmgtSaftyTrainingPlans","value","label",t.getTrainingPlanId()));
                             t.setCmgtSaftyTrainingRecordDetailList(cmgtSaftyTrainingRecordDetailDtoMapper.toDto(cmgtSaftyTrainingRecordDetailManager.selectListByTrainingId(t.getId())));


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyTrainingRecord t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyTrainingRecord t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyTrainingRecord t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyTrainingRecordDto dto) {
        CmgtSaftyTrainingRecord t = cmgtSaftyTrainingRecordDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            if (dto.getCmgtSaftyTrainingRecordDetailList() != null && dto.getCmgtSaftyTrainingRecordDetailList().size() > 0) {
                dto.getCmgtSaftyTrainingRecordDetailList().forEach(c -> {
                    CmgtSaftyTrainingRecordDetail e =  cmgtSaftyTrainingRecordDetailDtoMapper.toEntity(c);
                    e.setTrainingId(t.getId());
                    cmgtSaftyTrainingRecordDetailDao.insert(e);
                });
            }
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyTrainingRecordDto dto) {
        CmgtSaftyTrainingRecord t = cmgtSaftyTrainingRecordDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);

           List<CmgtSaftyTrainingRecordDetail> cmgtSaftyTrainingRecordDetails = cmgtSaftyTrainingRecordDetailManager.selectListByTrainingId(t.getId());
          for (CmgtSaftyTrainingRecordDetail cmgtSaftyTrainingRecordDetail: cmgtSaftyTrainingRecordDetails) {
               cmgtSaftyTrainingRecordDetailDao.deleteById(cmgtSaftyTrainingRecordDetail.getId());
          }
          if (dto.getCmgtSaftyTrainingRecordDetailList() != null && dto.getCmgtSaftyTrainingRecordDetailList().size() > 0) {
                dto.getCmgtSaftyTrainingRecordDetailList().forEach(c -> {
                    CmgtSaftyTrainingRecordDetail e =  cmgtSaftyTrainingRecordDetailDtoMapper.toEntity(c);
                    e.setTrainingId(t.getId());
                    e.setId(null);
                    cmgtSaftyTrainingRecordDetailDao.insert(e);
                });
            }

        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {
           List<CmgtSaftyTrainingRecordDetail> cmgtSaftyTrainingRecordDetails = cmgtSaftyTrainingRecordDetailManager.selectListByTrainingId(id);
          for (CmgtSaftyTrainingRecordDetail cmgtSaftyTrainingRecordDetail: cmgtSaftyTrainingRecordDetails) {
               cmgtSaftyTrainingRecordDetailDao.deleteById(cmgtSaftyTrainingRecordDetail.getId());
          }

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
