/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.client;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.codec.binary.Hex;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.tcp.TcpMessage;
import org.jetlinks.community.network.tcp.client.TcpClient;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class VertxTcpClient
implements TcpClient {
    private static final Logger log = LoggerFactory.getLogger(VertxTcpClient.class);
    public volatile NetClient client;
    public NetSocket socket;
    volatile PayloadParser payloadParser;
    private final String id;
    private long keepAliveTimeoutMs = Duration.ofMinutes(10L).toMillis();
    private volatile long lastKeepAliveTime = System.currentTimeMillis();
    private final List<Runnable> disconnectListener = new CopyOnWriteArrayList<Runnable>();
    private final Sinks.Many<TcpMessage> sink = Reactors.createMany();
    private final boolean serverClient;

    @Override
    public void keepAlive() {
        this.lastKeepAliveTime = System.currentTimeMillis();
    }

    @Override
    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeoutMs = timeout.toMillis();
    }

    @Override
    public void reset() {
        if (null != this.payloadParser) {
            this.payloadParser.reset();
        }
    }

    public InetSocketAddress address() {
        return this.getRemoteAddress();
    }

    public Mono<Void> sendMessage(EncodedMessage message) {
        return Mono.create(sink -> {
            if (this.socket == null) {
                sink.error((Throwable)new SocketException("socket closed"));
                return;
            }
            ByteBuf buf = message.getPayload();
            Buffer buffer = Buffer.buffer((ByteBuf)buf);
            int len = buffer.length();
            this.socket.write(buffer, r -> {
                ReferenceCountUtil.safeRelease((Object)buf);
                if (r.succeeded()) {
                    this.keepAlive();
                    sink.success();
                } else {
                    sink.error(r.cause());
                }
            });
        });
    }

    public Flux<EncodedMessage> receiveMessage() {
        return this.subscribe().cast(EncodedMessage.class);
    }

    public void disconnect() {
        this.shutdown();
    }

    public boolean isAlive() {
        return this.socket != null && (this.keepAliveTimeoutMs < 0L || System.currentTimeMillis() - this.lastKeepAliveTime < this.keepAliveTimeoutMs);
    }

    public boolean isAutoReload() {
        return true;
    }

    public VertxTcpClient(String id) {
        this.id = id;
        this.serverClient = true;
    }

    protected void received(TcpMessage message) {
        this.sink.emitNext((Object)message, Reactors.RETRY_NON_SERIALIZED);
    }

    @Override
    public Flux<TcpMessage> subscribe() {
        return this.sink.asFlux();
    }

    private void execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.warn("close tcp client error", (Throwable)e);
        }
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (null == this.socket) {
            return null;
        }
        SocketAddress socketAddress = this.socket.remoteAddress();
        return InetSocketAddress.createUnresolved(socketAddress.host(), socketAddress.port());
    }

    public NetworkType getType() {
        return DefaultNetworkType.TCP_CLIENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.socket == null) {
            return;
        }
        log.debug("tcp client [{}] disconnect", (Object)this.getId());
        VertxTcpClient vertxTcpClient = this;
        synchronized (vertxTcpClient) {
            if (null != this.client) {
                this.execute(() -> ((NetClient)this.client).close());
                this.client = null;
            }
            if (null != this.socket) {
                this.execute(() -> ((NetSocket)this.socket).close());
                this.socket = null;
            }
            if (null != this.payloadParser) {
                this.execute(this.payloadParser::close);
                this.payloadParser = null;
            }
        }
        for (Runnable runnable : this.disconnectListener) {
            this.execute(runnable);
        }
        this.disconnectListener.clear();
        if (this.serverClient) {
            this.sink.tryEmitComplete();
        }
    }

    public void setClient(NetClient client) {
        if (this.client != null && this.client != client) {
            this.client.close();
        }
        this.keepAlive();
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordParser(PayloadParser payloadParser) {
        VertxTcpClient vertxTcpClient = this;
        synchronized (vertxTcpClient) {
            if (null != this.payloadParser && this.payloadParser != payloadParser) {
                this.payloadParser.close();
            }
            this.payloadParser = payloadParser;
            this.payloadParser.handlePayload().subscribe(buffer -> this.received(new TcpMessage(buffer.getByteBuf())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocket(NetSocket socket) {
        VertxTcpClient vertxTcpClient = this;
        synchronized (vertxTcpClient) {
            Objects.requireNonNull(this.payloadParser);
            if (this.socket != null && this.socket != socket) {
                this.socket.close();
            }
            this.socket = socket.closeHandler(v -> this.shutdown()).handler(buffer -> {
                if (log.isDebugEnabled()) {
                    log.debug("handle tcp client[{}] payload:[{}]", (Object)socket.remoteAddress(), (Object)Hex.encodeHexString((byte[])buffer.getBytes()));
                }
                this.keepAlive();
                this.payloadParser.handle((Buffer)buffer);
                if (this.socket != socket) {
                    log.warn("tcp client [{}] memory leak ", (Object)socket.remoteAddress());
                    socket.close();
                }
            });
        }
    }

    @Override
    public Mono<Boolean> send(TcpMessage message) {
        return this.sendMessage(message).thenReturn((Object)true);
    }

    @Override
    public void onDisconnect(Runnable disconnected) {
        this.disconnectListener.add(disconnected);
    }

    public String getId() {
        return this.id;
    }

    public void setKeepAliveTimeoutMs(long keepAliveTimeoutMs) {
        this.keepAliveTimeoutMs = keepAliveTimeoutMs;
    }
}

