/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.server;

import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.tcp.client.TcpClient;
import org.jetlinks.community.network.tcp.client.VertxTcpClient;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.community.network.tcp.server.TcpServer;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class VertxTcpServer
implements TcpServer {
    private static final Logger log = LoggerFactory.getLogger(VertxTcpServer.class);
    Collection<NetServer> tcpServers;
    private Supplier<PayloadParser> parserSupplier;
    private long keepAliveTimeout = Duration.ofMinutes(10L).toMillis();
    private final String id;
    private final Sinks.Many<TcpClient> sink = Reactors.createMany((int)Integer.MAX_VALUE, (boolean)false);
    private String lastError;
    private InetSocketAddress bind;

    public VertxTcpServer(String id) {
        this.id = id;
    }

    @Override
    public Flux<TcpClient> handleConnection() {
        return this.sink.asFlux();
    }

    private void execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.warn("close tcp server error", (Throwable)e);
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bind;
    }

    public void setParserSupplier(Supplier<PayloadParser> parserSupplier) {
        this.parserSupplier = parserSupplier;
    }

    public void setServer(Collection<NetServer> servers) {
        if (this.tcpServers != null && !this.tcpServers.isEmpty()) {
            this.shutdown();
        }
        this.tcpServers = servers;
        for (NetServer tcpServer : this.tcpServers) {
            tcpServer.connectHandler(this::acceptTcpConnection);
        }
    }

    protected void acceptTcpConnection(NetSocket socket) {
        if (this.sink.currentSubscriberCount() == 0) {
            log.warn("not handler for tcp client[{}]", (Object)socket.remoteAddress());
            socket.close();
            return;
        }
        VertxTcpClient client = new VertxTcpClient(this.id + "_" + socket.remoteAddress());
        client.setKeepAliveTimeoutMs(this.keepAliveTimeout);
        try {
            socket.exceptionHandler(err -> log.error("tcp server client [{}] error", (Object)socket.remoteAddress(), err));
            client.setRecordParser(this.parserSupplier.get());
            client.setSocket(socket);
            this.sink.emitNext((Object)client, Reactors.emitFailureHandler());
            log.debug("accept tcp client [{}] connection", (Object)socket.remoteAddress());
        }
        catch (Exception e) {
            log.error("create tcp server client error", (Throwable)e);
            client.shutdown();
        }
    }

    public NetworkType getType() {
        return DefaultNetworkType.TCP_SERVER;
    }

    @Override
    public void shutdown() {
        if (null != this.tcpServers) {
            log.debug("close tcp server :[{}]", (Object)this.id);
            for (NetServer tcpServer : this.tcpServers) {
                this.execute(() -> ((NetServer)tcpServer).close());
            }
            this.tcpServers = null;
        }
    }

    public boolean isAlive() {
        return this.tcpServers != null;
    }

    public boolean isAutoReload() {
        return false;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getId() {
        return this.id;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    void setBind(InetSocketAddress bind) {
        this.bind = bind;
    }
}

