/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.parser.strateies;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.text.StringEscapeUtils;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;
import org.jetlinks.community.network.tcp.parser.strateies.VertxPayloadParserBuilder;

public class DelimitedPayloadParserBuilder
extends VertxPayloadParserBuilder {
    @Override
    public PayloadParserType getType() {
        return PayloadParserType.DELIMITED;
    }

    @Override
    protected Supplier<RecordParser> createParser(ValueObject config) {
        String delimited = config.getString("delimited").map(String::trim).orElseThrow(() -> new IllegalArgumentException("delimited can not be null"));
        if (delimited.startsWith("0x")) {
            byte[] hex = Hex.decodeHex((String)delimited.substring(2));
            return () -> RecordParser.newDelimited((Buffer)Buffer.buffer((byte[])hex));
        }
        return () -> RecordParser.newDelimited((String)StringEscapeUtils.unescapeJava((String)delimited));
    }
}

