/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.parser;

import io.vertx.core.buffer.Buffer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.community.network.tcp.parser.PayloadParserBuilderStrategy;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;
import org.jetlinks.community.network.tcp.parser.strateies.PipePayloadParser;

public class LengthFieldPayloadParserBuilder
implements PayloadParserBuilderStrategy {
    @Override
    public PayloadParserType getType() {
        return PayloadParserType.LENGTH_FIELD;
    }

    @Override
    public Supplier<PayloadParser> buildLazy(ValueObject config) {
        Function<Buffer, Integer> lengthParser;
        int offset = config.getInt("offset").orElse(0);
        int len = config.getInt("length").orElseGet(() -> config.getInt("to").orElse(4) - offset);
        boolean le = config.getBoolean("little").orElse(false);
        int initLength = offset + len;
        switch (len) {
            case 1: {
                lengthParser = buffer -> buffer.getUnsignedByte(offset);
                break;
            }
            case 2: {
                lengthParser = le ? buffer -> buffer.getUnsignedShort(offset) : buffer -> buffer.getUnsignedShort(offset);
                break;
            }
            case 3: {
                lengthParser = le ? buffer -> buffer.getUnsignedMediumLE(offset) : buffer -> buffer.getUnsignedMedium(offset);
                break;
            }
            case 4: {
                lengthParser = le ? buffer -> buffer.getIntLE(offset) : buffer -> buffer.getInt(offset);
                break;
            }
            case 8: {
                lengthParser = le ? buffer -> (int)buffer.getLongLE(offset) : buffer -> (int)buffer.getLong(offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal length:" + len);
            }
        }
        return () -> new PipePayloadParser().fixed(initLength).handler((buffer, parser) -> {
            int next = (Integer)lengthParser.apply((Buffer)buffer);
            parser.result((Buffer)buffer).fixed(next);
        }).handler((buffer, parser) -> parser.result((Buffer)buffer).complete());
    }
}

