/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.script;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jetlinks.community.script.ScriptFactory;

public abstract class AbstractScriptFactory
implements ScriptFactory {
    private final Utils utils = new Utils();
    static Class<?>[] DEFAULT_DENIES = new Class[]{System.class, File.class, Paths.class, ObjectInputStream.class, ObjectOutputStream.class, Thread.class, Runtime.class, ScriptEngine.class, ScriptEngineFactory.class};
    static Class<?>[] DEFAULT_ALLOWS = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Character.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.class, Short.class, Integer.class, Long.class, Character.class, Float.class, Double.class, Boolean.class, BigDecimal.class, BigInteger.class, String.class, HashMap.class, ConcurrentHashMap.class, LinkedHashMap.class, Date.class, LocalDateTime.class, ArrayList.class, LinkedList.class};
    private final Set<String> denies = new HashSet<String>();
    private final Set<String> allows = new HashSet<String>();

    public AbstractScriptFactory() {
        this.denies.add("*");
        this.allows(DEFAULT_ALLOWS);
    }

    @Override
    public final void allows(Collection<Class<?>> allowTypes) {
        this.allows.addAll(allowTypes.stream().map(Class::getName).collect(Collectors.toList()));
    }

    @Override
    public final void allows(Class<?> ... allowTypes) {
        this.allows(Arrays.asList(allowTypes));
    }

    @Override
    public final void denies(Collection<Class<?>> allowTypes) {
        this.denies.addAll(allowTypes.stream().map(Class::getName).collect(Collectors.toList()));
    }

    @Override
    public final void denies(Class<?> ... allowTypes) {
        this.denies(Arrays.asList(allowTypes));
    }

    @Override
    public void allowsPattern(String ... allowTypes) {
        this.allowsPattern(Arrays.asList(allowTypes));
    }

    @Override
    public void allowsPattern(Collection<String> allowTypes) {
    }

    @Override
    public void deniesPattern(String ... allowTypes) {
        this.deniesPattern(Arrays.asList(allowTypes));
    }

    @Override
    public void deniesPattern(Collection<String> allowTypes) {
    }

    public final boolean isDenied(Class<?> type) {
        return this.isDenied(type.getName());
    }

    public final boolean isDenied(String typeName) {
        if (this.allows.contains(typeName)) {
            return false;
        }
        return this.denies.contains("*") || this.denies.contains(typeName);
    }

    public Utils getUtils() {
        return this.utils;
    }

    public class Utils {
        private Utils() {
        }

        public Object toJavaType(Object obj) {
            return AbstractScriptFactory.this.convertToJavaType(obj);
        }
    }
}

