package com.artfess.file.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 附件配置信息
 *
 * @author wh
 * @company rzx
 * @since 2021-03-04
 */
@ApiModel(value = "FileConfig对象", description = "附件配置信息")
@TableName("PORTAL_SYS_FILE_CONFIG")
public class FileConfig extends AutoFillModel<FileConfig> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_")
    private String id;

    @ApiModelProperty(value = "附件存储配置ID")
    @TableField("STORAGE_ID_")
    private String storageId;

    @ApiModelProperty(value = "附件配置编码(唯一)")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "附件配置名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "附件上传大小（MB）")
    @TableField("ALLOW_SIZE_")
    private Double allowSize;

    @ApiModelProperty(value = "是否允许删除（0：否，1：是）")
    @TableField("ALLOW_DELETE_")
    private Integer allowDelete;

    @ApiModelProperty(value = "是否允许同时上传多个（0：否，1：是）")
    @TableField("ALLOW_MULTIPLE_")
    private Integer allowMultiple;

    @ApiModelProperty(value = "允许上传附件类型")
    @TableField("FILE_KINDS_")
    private String fileKinds;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(name="storageName", notes="附件存储配置名")
    @TableField(exist = false)
    protected String storageName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStorageId() {
        return storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getAllowSize() {
        return allowSize;
    }

    public void setAllowSize(Double allowSize) {
        this.allowSize = allowSize;
    }

    public Integer getAllowDelete() {
        return allowDelete;
    }

    public void setAllowDelete(Integer allowDelete) {
        this.allowDelete = allowDelete;
    }

    public Integer getAllowMultiple() {
        return allowMultiple;
    }

    public void setAllowMultiple(Integer allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public String getFileKinds() {
        return fileKinds;
    }

    public void setFileKinds(String fileKinds) {
        this.fileKinds = fileKinds;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getStorageName() {
        return storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    @Override
    public String toString() {
        return "FileConfig{" +
                "id=" + id +
                ", code=" + code +
                ", name=" + name +
                ", allowDelete=" + allowDelete +
                ", allowMultiple=" + allowMultiple +
                ", fileKinds=" + fileKinds +
                ", memo=" + memo +
                ", storageName=" + storageName +
                "}";
    }
}
