/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bizAccessory/v1/"})
@Api(tags={"\u9644\u4ef6\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class AccessoryController
extends BaseController<AccessoryManager, Accessory> {
    private static final Logger log = LoggerFactory.getLogger(AccessoryController.class);
    @Resource
    AccessoryManager accessoryManager;

    @PostMapping(value={"/minioDrawingUpload"})
    @ApiOperation(value="\u5de5\u7a0b\u56fe\u7eb8\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<String> minioDrawingUpload(MultipartFile file, @ApiParam(name="sourceId", value="\u8d44\u6e90Id", required=true) @RequestParam(value="sourceId", required=true) String sourceId) {
        return new CommonResult(((AccessoryManager)this.baseService).minioDrawingUpload(file, sourceId));
    }

    @PostMapping(value={"/minioWorkOrderUpload"})
    @ApiOperation(value="\u5de5\u5355\u65bd\u5de5\u56fe\u7247\u4e0a\u4f20")
    public String minioWorkOrderUpload(MultipartFile file, @ApiParam(name="sourceId", value="\u8d44\u6e90Id", required=true) @RequestParam(value="sourceId", required=true) String sourceId) {
        return ((AccessoryManager)this.baseService).minioDrawingUpload(file, sourceId);
    }

    @RequestMapping(value={"/saveAccessory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58,\u4fee\u6539\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveAccessory(@ApiParam(name="bizBridgeInformation", value="\u6865\u6881\u5bf9\u8c61") @RequestBody Accessory accessory) throws Exception {
        String msg = "\u6dfb\u52a0\u6210\u529f";
        if (StringUtils.isEmpty((CharSequence)accessory.getId())) {
            accessory.setIsDele("0");
            ((AccessoryManager)this.baseService).create((Model)accessory);
        } else {
            ((AccessoryManager)this.baseService).update((Model)accessory);
            msg = "\u4fee\u6539\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public PageList<Accessory> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Accessory> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageList pageList = ((AccessoryManager)this.baseService).query(queryFilter);
        return pageList;
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f")
    public Accessory get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (Accessory)((Object)((AccessoryManager)this.baseService).getById((Serializable)((Object)id)));
    }

    @GetMapping(value={"getBySourceId/{id}"})
    @ApiOperation(value="\u6839\u636esourceID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f")
    public List<Accessory> getBySourceId(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return ((AccessoryManager)this.baseService).getAccessoryBySourceId(id);
    }

    @RequestMapping(value={"/updateBridge"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST", notes="\u903b\u8f91\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    public CommonResult<String> updateBridge(@ApiParam(name="ids", value="\u53ef\u89c6\u5316\u5206\u7c7bID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            ((AccessoryManager)this.baseService).update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/minioDrawingdownFile"})
    @ApiOperation(value="\u5de5\u7a0b\u56fe\u7eb8\u6587\u4ef6\u5bfc\u51fa\u63a5\u53e3", httpMethod="GET", notes="\u5de5\u7a0b\u56fe\u7eb8\u6587\u4ef6\u5bfc\u51fa\u63a5\u53e3")
    public void downFile(HttpServletResponse response, @ApiParam(name="ids", value="\u591a\u4e2a\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            try {
                List<String> idsList = Arrays.asList(ids.split(","));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"id_", idsList);
                queryWrapper.ne((Object)"is_dele_", (Object)"1");
                String path = System.getProperty("user.dir") + "\\access";
                List accessoryList = ((AccessoryManager)this.baseService).list((Wrapper)queryWrapper);
                if (null != accessoryList && accessoryList.size() > 0) {
                    for (Accessory accessory : accessoryList) {
                        String url = accessory.getUrl();
                        String name = accessory.getName();
                        InputStream fileStream = MinioUtil.getMinioFile((String)"yhxt", (String)url, (boolean)false);
                        String filePath = path + "\\" + name;
                        File targetFile = new File(filePath);
                        if (!targetFile.exists()) {
                            if (!targetFile.getParentFile().exists()) {
                                targetFile.getParentFile().mkdir();
                            }
                            targetFile.createNewFile();
                        }
                        log.info(String.format("\u6587\u4ef6\u7684\u8def\u5f84%s", filePath));
                        FileUtils.copyInputStreamToFile((InputStream)fileStream, (File)targetFile);
                    }
                    log.info(String.format("\u6587\u4ef6\u7684\u5bfc\u51fa\u8def\u5f84%s", path));
                    ZipUtil.zip((String)path, (Boolean)true);
                    HttpUtil.downLoadFile((HttpServletResponse)response, (String)(path + ".zip"), (String)"\u5de5\u7a0b\u56fe\u7eb8\u6587\u4ef6.zip");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"updateAccessory"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664", httpMethod="DELETE", notes="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    public CommonResult<String> updateAccessory(@ApiParam(name="ids", value="\u9644\u4ef6ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id_", idsList);
            updateWrapper.set((Object)"is_dele_", (Object)"1");
            this.accessoryManager.update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/minIoAllDownFile"})
    @ApiOperation(value="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void downTest(@ApiParam(name="ids", value="ids", required=true) @RequestParam(value="ids", required=true) String ids, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((AccessoryManager)this.baseService).minIoDownFile(ids, bizPath, response);
    }

    @RequestMapping(value={"/minioUpload"})
    @ApiOperation(value="\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<Accessory> minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        Accessory accessory = ((AccessoryManager)this.baseService).minioUpload(file, bizPath, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)accessory);
    }
}

