/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.manager.impl;

import com.artfess.base.exception.NotFoundException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.service.dao.ServiceParamDao;
import com.artfess.service.dao.ServiceSetDao;
import com.artfess.service.manager.ServiceSetManager;
import com.artfess.service.model.ServiceParam;
import com.artfess.service.model.ServiceSet;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceSetManagerImpl
extends BaseManagerImpl<ServiceSetDao, ServiceSet>
implements ServiceSetManager {
    @Resource
    ServiceParamDao serviceParamDao;

    @Override
    public ServiceSet getByAlias(String alias) {
        ServiceSet serviceSet = ((ServiceSetDao)this.baseMapper).getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)serviceSet))) {
            throw new NotFoundException(String.format("\u672a\u627e\u5230\u522b\u540d\u4e3a: %s \u7684\u8bb0\u5f55", alias));
        }
        String setId = serviceSet.getId();
        List<ServiceParam> paramList = this.serviceParamDao.getBySetId(setId);
        serviceSet.setServiceParamList(paramList);
        return serviceSet;
    }

    @Override
    @Transactional
    public void saveData(ServiceSet serviceSet) {
        String setId = serviceSet.getId();
        if (StringUtil.isEmpty((String)setId)) {
            setId = UniqueIdUtil.getSuid();
            serviceSet.setId(setId);
            this.create((Model)serviceSet);
        } else {
            this.update((Model)serviceSet);
        }
        this.serviceParamDao.removeBySetId(setId);
        List<ServiceParam> sysServiceParamList = serviceSet.getServiceParamList();
        for (ServiceParam param : sysServiceParamList) {
            param.setSetId(setId);
            param.setId(UniqueIdUtil.getSuid());
            this.serviceParamDao.insert((Object)param);
        }
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.serviceParamDao.removeBySetId(id);
            this.remove((Serializable)((Object)id));
        }
    }
}

