/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.client;

import com.artfess.base.service.InvokeCmd;
import com.artfess.base.service.InvokeResult;
import com.artfess.base.service.ServiceClient;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.service.dao.ServiceSetDao;
import com.artfess.service.model.DefaultInvokeCmd;
import com.artfess.service.model.ServiceSet;
import com.artfess.service.util.ParamHandlerUtil;
import com.artfess.service.ws.WebServiceClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ServiceClientImpl
implements ServiceClient {
    @Resource
    ServiceSetDao sysServiceSetDao;

    public InvokeResult invoke(InvokeCmd invokeCmd) {
        WebServiceClient webServiceClient = (WebServiceClient)AppUtil.getBean(WebServiceClient.class);
        if ("webservice".equals(invokeCmd.getType())) {
            return webServiceClient.invoke(invokeCmd);
        }
        return null;
    }

    public InvokeResult invoke(String alias, Map<String, Object> map) {
        ServiceSet serviceSet = this.sysServiceSetDao.getByAlias(alias);
        DefaultInvokeCmd invokeCmd = new DefaultInvokeCmd();
        invokeCmd.setAddress(serviceSet.getAddress());
        invokeCmd.setOperatorName(serviceSet.getMethodName());
        invokeCmd.setOperatorNamespace(serviceSet.getNamespace());
        invokeCmd.setNeedPrefix(serviceSet.getSoapAction() == 'Y');
        InvokeResult result = null;
        try {
            String params = this.getJsonParam(map, serviceSet.getInputSet());
            invokeCmd.setJsonParam(params);
            result = this.invoke(invokeCmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private String getJsonParam(Map<String, Object> variables, String inputSet) throws IOException {
        ArrayNode jsonElement = (ArrayNode)JsonUtil.toJsonNode((String)inputSet);
        ObjectNode jsonParamObj = JsonUtil.getMapper().createObjectNode();
        if (jsonElement.isArray()) {
            ParamHandlerUtil.buildJsonParam(jsonElement, (JsonNode)jsonParamObj, variables, "input");
        }
        String ss = jsonParamObj.toString();
        return ss;
    }
}

