/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.service;

import com.artfess.base.cache.impl.AbstractValueAdaptingCache;
import com.artfess.base.cache.setting.SecondaryCacheSetting;
import com.artfess.base.cache.support.NullValue;
import com.artfess.base.util.BeanUtils;
import com.artfess.redis.service.RedisCacheKey;
import com.artfess.redis.support.AwaitThreadContainer;
import com.artfess.redis.support.Lock;
import com.artfess.redis.util.RedisHelper;
import com.artfess.redis.util.ThreadTaskUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisCache
extends AbstractValueAdaptingCache {
    protected static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static final int RETRY_COUNT = 20;
    private static final long WAIT_TIME = 20L;
    private AwaitThreadContainer container = new AwaitThreadContainer();
    private RedisTemplate<String, Object> redisTemplate;
    private long expiration;
    private long preloadTime = 0L;
    private boolean forceRefresh = false;
    private boolean usePrefix;
    private final boolean allowNullValues;
    private final TimeUnit timeUnit;
    private final int magnification;

    public RedisCache(String name, RedisTemplate<String, Object> redisTemplate, SecondaryCacheSetting secondaryCacheSetting) {
        super(name);
        this.redisTemplate = redisTemplate;
        this.expiration = secondaryCacheSetting.getExpiration();
        this.preloadTime = secondaryCacheSetting.getPreloadTime();
        this.forceRefresh = secondaryCacheSetting.isForceRefresh();
        this.usePrefix = secondaryCacheSetting.isUsePrefix();
        this.allowNullValues = secondaryCacheSetting.isAllowNullValue();
        this.magnification = secondaryCacheSetting.getMagnification();
        this.timeUnit = secondaryCacheSetting.getTimeUnit();
    }

    public RedisTemplate<String, Object> getNativeCache() {
        return this.redisTemplate;
    }

    public RedisCacheKey getRedisCacheKey(Object key) {
        return new RedisCacheKey(key, this.redisTemplate.getKeySerializer()).cacheName(this.getName()).usePrefix(this.usePrefix);
    }

    public Object get(Object key) {
        RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
        logger.debug("redis\u7f13\u5b58 key= {} \u67e5\u8be2redis\u7f13\u5b58", (Object)redisCacheKey.getKey());
        return this.redisTemplate.opsForValue().get((Object)redisCacheKey.getKey());
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
        logger.debug("redis\u7f13\u5b58 key= {} \u67e5\u8be2redis\u7f13\u5b58\u5982\u679c\u6ca1\u6709\u547d\u4e2d\uff0c\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u6570\u636e", (Object)redisCacheKey.getKey());
        Object result = this.redisTemplate.opsForValue().get((Object)redisCacheKey.getKey());
        if (result != null || this.redisTemplate.hasKey((Object)redisCacheKey.getKey()).booleanValue()) {
            this.refreshCache(redisCacheKey, valueLoader, result);
            return (T)this.fromStoreValue(result);
        }
        return this.executeCacheMethod(redisCacheKey, valueLoader);
    }

    public void put(Object key, Object value) {
        RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
        logger.debug("redis\u7f13\u5b58 key= {} put\u7f13\u5b58", (Object)redisCacheKey.getKey());
        this.putValue(redisCacheKey, value);
    }

    public Object putIfAbsent(Object key, Object value) {
        logger.debug("redis\u7f13\u5b58 key= {} putIfAbsent\u7f13\u5b58", (Object)this.getRedisCacheKey(key).getKey());
        Object reult = this.get(key);
        if (reult != null) {
            return reult;
        }
        this.put(key, value);
        return null;
    }

    public void evict(Object key) {
        RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
        logger.info("\u6e05\u9664redis\u7f13\u5b58 key= {} ", (Object)redisCacheKey.getKey());
        this.redisTemplate.delete((Object)redisCacheKey.getKey());
    }

    public void evictAll(Iterable<? extends Object> keys) {
    }

    public void clear() {
        if (this.usePrefix) {
            logger.info("\u6e05\u7a7aredis\u7f13\u5b58 \uff0c\u7f13\u5b58\u524d\u7f00\u4e3a{}", (Object)this.getName());
            Set<String> keys = RedisHelper.scan(this.redisTemplate, this.getName() + "*");
            if (!CollectionUtils.isEmpty(keys)) {
                this.redisTemplate.delete(keys);
            }
        }
    }

    public List<Object> getRightKeys(String prex) {
        Set keys = this.redisTemplate.keys((Object)(prex + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            Set keys1 = this.redisTemplate.keys((Object)(prex + "*"));
            List list = this.redisTemplate.opsForValue().multiGet((Collection)keys1);
            return list;
        }
        return null;
    }

    public Map<String, Object> getKeysValues(String path) {
        Set keys = this.redisTemplate.keys((Object)(path + "*"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            for (String key : keys) {
                key = key.replace(path + ":", "");
                Object value = this.get(key);
                map.put(path + ":" + key, value);
            }
            return map;
        }
        return null;
    }

    public void delLike(String prex) {
        Set keys = this.redisTemplate.keys((Object)(prex + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    private <T> T executeCacheMethod(RedisCacheKey redisCacheKey, Callable<T> valueLoader) {
        Lock redisLock = new Lock(this.redisTemplate, redisCacheKey.getKey() + "_sync_lock");
        for (int i = 0; i < 20; ++i) {
            try {
                Object result = this.redisTemplate.opsForValue().get((Object)redisCacheKey.getKey());
                if (result != null) {
                    logger.debug("redis\u7f13\u5b58 key= {} \u83b7\u53d6\u5230\u9501\u540e\u67e5\u8be2\u67e5\u8be2\u7f13\u5b58\u547d\u4e2d\uff0c\u4e0d\u9700\u8981\u6267\u884c\u88ab\u7f13\u5b58\u7684\u65b9\u6cd5", (Object)redisCacheKey.getKey());
                    Object object = this.fromStoreValue(result);
                    return (T)object;
                }
                if (redisLock.lock()) {
                    T t = this.loaderAndPutValue(redisCacheKey, valueLoader, true);
                    logger.debug("redis\u7f13\u5b58 key= {} \u4ece\u6570\u636e\u5e93\u83b7\u53d6\u6570\u636e\u5b8c\u6bd5\uff0c\u5524\u9192\u6240\u6709\u7b49\u5f85\u7ebf\u7a0b", (Object)redisCacheKey.getKey());
                    this.container.signalAll(redisCacheKey.getKey());
                    T t2 = t;
                    return t2;
                }
                logger.debug("redis\u7f13\u5b58 key= {} \u4ece\u6570\u636e\u5e93\u83b7\u53d6\u6570\u636e\u672a\u83b7\u53d6\u5230\u9501\uff0c\u8fdb\u5165\u7b49\u5f85\u72b6\u6001\uff0c\u7b49\u5f85{}\u6beb\u79d2", (Object)redisCacheKey.getKey(), (Object)20L);
                this.container.await(redisCacheKey.getKey(), 20L);
                continue;
            }
            catch (Exception e) {
                this.container.signalAll(redisCacheKey.getKey());
                throw new AbstractValueAdaptingCache.LoaderCacheValueException((AbstractValueAdaptingCache)this, (Object)redisCacheKey.getKey(), (Throwable)e);
            }
            finally {
                redisLock.unlock();
            }
        }
        logger.debug("redis\u7f13\u5b58 key={} \u7b49\u5f85{}\u6b21\uff0c\u5171{}\u6beb\u79d2\uff0c\u4efb\u672a\u83b7\u53d6\u5230\u7f13\u5b58\uff0c\u76f4\u63a5\u53bb\u6267\u884c\u88ab\u7f13\u5b58\u7684\u65b9\u6cd5", new Object[]{redisCacheKey.getKey(), 20, 400L, 20L});
        return this.loaderAndPutValue(redisCacheKey, valueLoader, true);
    }

    private <T> T loaderAndPutValue(RedisCacheKey key, Callable<T> valueLoader, boolean isLoad) {
        long start = System.currentTimeMillis();
        try {
            Object result = this.putValue(key, valueLoader.call());
            logger.debug("redis\u7f13\u5b58 key={} \u6267\u884c\u88ab\u7f13\u5b58\u7684\u65b9\u6cd5\uff0c\u5e76\u5c06\u5176\u653e\u5165\u7f13\u5b58, \u8017\u65f6\uff1a{}\u3002", (Object)key.getKey(), (Object)(System.currentTimeMillis() - start));
            return (T)this.fromStoreValue(result);
        }
        catch (Exception e) {
            throw new AbstractValueAdaptingCache.LoaderCacheValueException((AbstractValueAdaptingCache)this, (Object)key.getKey(), (Throwable)e);
        }
    }

    private Object putValue(RedisCacheKey key, Object value) {
        Object result = this.toStoreValue(value);
        if (result == null) {
            return result;
        }
        if (!this.isAllowNullValues() && result instanceof NullValue) {
            this.redisTemplate.delete((Object)key.getKey());
            return result;
        }
        long expirationTime = this.expiration;
        if (this.isAllowNullValues() && result instanceof NullValue) {
            expirationTime /= (long)this.getMagnification();
        }
        if (expirationTime <= 0L) {
            this.redisTemplate.opsForValue().set((Object)key.getKey(), result);
        } else {
            this.redisTemplate.opsForValue().set((Object)key.getKey(), result, expirationTime, this.timeUnit);
        }
        return result;
    }

    private <T> void refreshCache(RedisCacheKey redisCacheKey, Callable<T> valueLoader, Object result) {
        boolean flag;
        Long ttl = this.redisTemplate.getExpire((Object)redisCacheKey.getKey());
        Long preload = this.preloadTime;
        boolean bl = flag = this.isAllowNullValues() && (result instanceof NullValue || result == null);
        if (flag) {
            preload = preload / (long)this.getMagnification();
        }
        if (null != ttl && ttl > 0L && TimeUnit.SECONDS.toMillis(ttl) <= preload) {
            if (!this.getForceRefresh()) {
                logger.debug("redis\u7f13\u5b58 key={} \u8f6f\u5237\u65b0\u7f13\u5b58\u6a21\u5f0f", (Object)redisCacheKey.getKey());
                this.softRefresh(redisCacheKey);
            } else {
                logger.debug("redis\u7f13\u5b58 key={} \u5f3a\u5237\u65b0\u7f13\u5b58\u6a21\u5f0f", (Object)redisCacheKey.getKey());
                this.forceRefresh(redisCacheKey, valueLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void softRefresh(RedisCacheKey redisCacheKey) {
        Lock redisLock = new Lock(this.redisTemplate, redisCacheKey.getKey() + "_lock");
        try {
            if (redisLock.tryLock()) {
                this.redisTemplate.expire((Object)redisCacheKey.getKey(), this.expiration, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            redisLock.unlock();
        }
    }

    private <T> void forceRefresh(RedisCacheKey redisCacheKey, Callable<T> valueLoader) {
        ThreadTaskUtils.run(() -> {
            Lock redisLock = new Lock(this.redisTemplate, redisCacheKey.getKey() + "_lock");
            try {
                Long ttl;
                if (redisLock.lock() && null != (ttl = this.redisTemplate.getExpire((Object)redisCacheKey.getKey())) && ttl > 0L && TimeUnit.SECONDS.toMillis(ttl) <= this.preloadTime) {
                    this.loaderAndPutValue(redisCacheKey, valueLoader, false);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                redisLock.unlock();
            }
        });
    }

    private boolean getForceRefresh() {
        return this.forceRefresh;
    }

    public int getMagnification() {
        return this.magnification;
    }

    public Map<String, String> getAll(Iterable<String> keys, String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (BeanUtils.isEmpty(keys)) {
            return map;
        }
        HashMap<String, List> newMap = new HashMap<String, List>();
        for (String string : keys) {
            RedisCacheKey redisCacheKey = this.getRedisCacheKey(string);
            List multiGet = this.redisTemplate.opsForHash().multiGet((Object)redisCacheKey.getKey(), Arrays.asList(type));
            newMap.put(string, multiGet);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(list.get(0))) {
                map.put(key, String.valueOf(list.get(0)));
                continue;
            }
            map.put(key, key);
        }
        return map;
    }

    public void putAll(Map<String, Map<String, String>> map) {
        if (BeanUtils.isEmpty(map)) {
            return;
        }
        try {
            for (Map.Entry<String, Map<String, String>> next : map.entrySet()) {
                String key = next.getKey();
                RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
                Map<String, String> value = next.getValue();
                this.redisTemplate.opsForHash().putAll((Object)redisCacheKey.getKey(), value);
            }
        }
        catch (Exception ex) {
            logger.error("\u6279\u91cf\u5b58\u653e\u6570\u636e\u5230\u7f13\u5b58\u4e2d\u65f6\u51fa\u9519\u4e86\uff1a", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
        }
    }

    public void hdel(String key, String field) {
        RedisCacheKey redisCacheKey = this.getRedisCacheKey(key);
        this.redisTemplate.opsForHash().delete((Object)redisCacheKey.getKey(), new Object[]{field});
    }
}

