package com.artfess.form.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.util.JsonUtil;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.FormRemindData;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 提醒业务对象 前端控制器
 *
 * @author 超级管理员
 * @company 广州宏天软件股份有限公司
 * @since 2020-07-07
 */
@RestController
@RequestMapping("/form/formRemindData/v1/")
public class FormRemindDataController extends BaseController<FormRemindDataManager, FormRemindData> {

    @RequestMapping(value = "deleteFormRemindDataByBoDataId", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "删除提醒", httpMethod = "DELETE", notes = "删除提醒")
    public void deleteFormRemindDataByBoDataId(@ApiParam(name = "boDataId", value = "业务数据主键") @RequestParam String boDataId) throws IOException {
        baseService.deleteFormRemindDataByBoDataId(new QueryWrapper<FormRemindData>().eq("OPEM_ID", boDataId));
    }

    @RequestMapping(value = "saveBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "添加提醒", httpMethod = "POST", notes = "添加提醒")
    public void saveBatch(@ApiParam(name = "list", value = "实体信息") @RequestBody List<ObjectNode> list) throws IOException {
        List<FormRemindData> formRemindDataList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            formRemindDataList.add(JsonUtil.toBean(list.get(i), FormRemindData.class));
        }
        baseService.saveBatch(formRemindDataList);
    }

    @RequestMapping(value = "getFormRemindDataByUser", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取当前用户的提醒内容", httpMethod = "GET", notes = "获取当前用户的提醒内容")
    public List<FormRemindData> getFormRemindDataByUser() throws IOException {
        return baseService.getFormRemindDataByUser();
    }

}
