package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.form.model.FieldAuth;

/**
 * 字段授权管理
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
public interface FieldAuthManager extends BaseManager<FieldAuth> {
    /**
     * 通过实体名获取字段权限设置
     *
     * @param entName
     * @return
     */
    FieldAuth getByEntName(String entName);

    /**
     * 通过表名获取字段权限设置
     *
     * @param tableName
     * @return
     */
    FieldAuth getByTableName(String tableName);

    /**
     * 通过类名获取字段权限设置
     *
     * @param className
     * @return
     */
    FieldAuth getByClassName(String className);
}
