/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialcheck.vo.ApplicationForChangeOfContractVo;
import com.artfess.yhxt.specialproject.dao.BizApplicationForChangeOfContractDao;
import com.artfess.yhxt.specialproject.manager.BizApplicationForChangeOfContractManager;
import com.artfess.yhxt.specialproject.manager.BizContractChangeInvalidManager;
import com.artfess.yhxt.specialproject.manager.BizContractDetailChangeInvalidManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.model.BizApplicationForChangeOfContract;
import com.artfess.yhxt.specialproject.model.BizContractChangeInvalid;
import com.artfess.yhxt.specialproject.model.BizContractDetailChangeInvalid;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.model.BizProjectContractDetails;
import com.artfess.yhxt.specialproject.vo.ChangeContractVo;
import com.artfess.yhxt.specialproject.vo.ProjectContractVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizApplicationForChangeOfContractManagerImpl
extends BaseManagerImpl<BizApplicationForChangeOfContractDao, BizApplicationForChangeOfContract>
implements BizApplicationForChangeOfContractManager {
    @Resource
    private BizContractChangeInvalidManager bizContractChangeInvalidManager;
    @Resource
    private BizContractDetailChangeInvalidManager bizContractDetailChangeInvalidManager;
    @Resource
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private BizProjectContractDetailsManager bizProjectContractDetailsManager;
    @Resource
    private BaseContext baseContext;

    @Override
    public PageList<BizApplicationForChangeOfContract> queryBizApplicationForChangeOfContract(QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        IPage<BizApplicationForChangeOfContract> result = ((BizApplicationForChangeOfContractDao)this.baseMapper).queryBizApplicationForChangeOfContract((IPage<BizApplicationForChangeOfContract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizApplicationForChangeOfContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizApplicationForChangeOfContract getBizApplicationForChangeOfContractById(String id) {
        BizApplicationForChangeOfContract bizApplicationForChangeOfContract = (BizApplicationForChangeOfContract)((Object)((BizApplicationForChangeOfContractDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return bizApplicationForChangeOfContract;
    }

    @Override
    public void saveVo(ApplicationForChangeOfContractVo vo) {
        BizApplicationForChangeOfContract applicationForChangeOfContract = vo.getBizApplicationForChangeOfContract();
        applicationForChangeOfContract.setChangeApplyUser(this.baseContext.getCurrentUserName());
        applicationForChangeOfContract.setChangeApplyUnit(this.baseContext.getCurrentOrgName());
        applicationForChangeOfContract.setChangeApplyDate(LocalDate.now());
        applicationForChangeOfContract.setChangeConfirmStatus(0);
        this.checkContractId(applicationForChangeOfContract);
        this.saveOrUpdate((Object)applicationForChangeOfContract);
        BizContractChangeInvalid bizContractChangeInvalid = vo.getBizContractChangeInvalid();
        bizContractChangeInvalid.setContractId(applicationForChangeOfContract.getContractId());
        this.bizContractChangeInvalidManager.saveOrUpdate((Object)bizContractChangeInvalid);
        List<BizContractDetailChangeInvalid> list = vo.getBizContractDetailChangeInvalidList();
        for (BizContractDetailChangeInvalid bizContractDetailChangeInvalid : list) {
            bizContractDetailChangeInvalid.setContractId(applicationForChangeOfContract.getContractId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CONTRACT_ID_", (Object)applicationForChangeOfContract.getContractId());
        this.bizContractDetailChangeInvalidManager.getBaseMapper().delete((Wrapper)queryWrapper);
        this.bizContractDetailChangeInvalidManager.saveBatch(list);
    }

    @Override
    public PageList<ProjectContractVo> queryApplicationForChangeOfContractVo(QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        IPage<ProjectContractVo> result = ((BizApplicationForChangeOfContractDao)this.baseMapper).queryApplicationForChangeOfContractVo((IPage<BizApplicationForChangeOfContract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizApplicationForChangeOfContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public ChangeContractVo getChangeContractVoById(String id) {
        ChangeContractVo changeContractVo = new ChangeContractVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List bizApplicationForChangeOfContracts = ((BizApplicationForChangeOfContractDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (bizApplicationForChangeOfContracts.size() == 0) {
            return null;
        }
        BizProjectContract projectContract = (BizProjectContract)((Object)this.bizProjectContractManager.getById((Serializable)((Object)id)));
        QueryWrapper detailsQueryWrapper = new QueryWrapper();
        detailsQueryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        detailsQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List contractDetails = this.bizProjectContractDetailsManager.getBaseMapper().selectList((Wrapper)detailsQueryWrapper);
        QueryWrapper invalidQueryWrapper = new QueryWrapper();
        invalidQueryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        invalidQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List invalidList = this.bizContractChangeInvalidManager.getBaseMapper().selectList((Wrapper)invalidQueryWrapper);
        QueryWrapper detailInvalidQueryWrapper = new QueryWrapper();
        detailInvalidQueryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
        detailInvalidQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List bizContractDetailChangeInvalids = this.bizContractDetailChangeInvalidManager.getBaseMapper().selectList((Wrapper)detailInvalidQueryWrapper);
        changeContractVo.setBizProjectContract(projectContract);
        changeContractVo.setBizProjectContractDetailsList(contractDetails);
        if (invalidList.size() > 0) {
            changeContractVo.setBizContractChangeInvalid((BizContractChangeInvalid)((Object)invalidList.get(0)));
        }
        if (bizApplicationForChangeOfContracts.size() > 0) {
            changeContractVo.setBizApplicationForChangeOfContract((BizApplicationForChangeOfContract)((Object)bizApplicationForChangeOfContracts.get(0)));
        }
        changeContractVo.setBizContractDetailChangeInvalidList(bizContractDetailChangeInvalids);
        return changeContractVo;
    }

    @Override
    @Transactional
    public void synchronousContractData(ChangeContractVo vo) {
        BizProjectContract bizProjectContract = vo.getBizProjectContract();
        BizContractChangeInvalid bizContractChangeInvalid = vo.getBizContractChangeInvalid();
        List<BizContractDetailChangeInvalid> bizContractDetailChangeInvalidList = vo.getBizContractDetailChangeInvalidList();
        BizApplicationForChangeOfContract bizApplicationForChangeOfContract = vo.getBizApplicationForChangeOfContract();
        bizApplicationForChangeOfContract.setChangeExecuteUser(this.baseContext.getCurrentUserName());
        bizApplicationForChangeOfContract.setChangeExecuteUnit(this.baseContext.getCurrentOrgName());
        bizApplicationForChangeOfContract.setChangeExecuteDate(LocalDate.now());
        String contractId = bizApplicationForChangeOfContract.getContractId();
        if (contractId.equals(bizProjectContract.getId())) {
            String contractAmount;
            String contractName = bizContractChangeInvalid.getContractName();
            if (StringUtils.isNotEmpty((CharSequence)contractName)) {
                bizProjectContract.setContractName(contractName);
            }
            if (StringUtils.isNotEmpty((CharSequence)(contractAmount = bizContractChangeInvalid.getContractAmount()))) {
                bizProjectContract.setContractAmount(contractAmount);
            }
        }
        if (StringUtils.isEmpty((CharSequence)contractId)) {
            return;
        }
        this.bizProjectContractDetailsManager.removeContract(contractId);
        ArrayList<BizProjectContractDetails> bizProjectContractDetailsList = new ArrayList<BizProjectContractDetails>();
        for (BizContractDetailChangeInvalid bizContractDetailChangeInvalid : bizContractDetailChangeInvalidList) {
            BizProjectContractDetails bizProjectContractDetails = new BizProjectContractDetails();
            bizProjectContractDetails.setContractId(bizContractDetailChangeInvalid.getContractId());
            bizProjectContractDetails.setSubjectNumber(bizContractDetailChangeInvalid.getSubSubjectNumber());
            bizProjectContractDetails.setSubjectName(bizContractDetailChangeInvalid.getSubjectName());
            bizProjectContractDetails.setSubSubjectNumber(bizContractDetailChangeInvalid.getSubSubjectNumber());
            bizProjectContractDetails.setSubSubjectName(bizContractDetailChangeInvalid.getSubSubjectName());
            bizProjectContractDetails.setSubjectPrice(bizContractDetailChangeInvalid.getSubjectPrice());
            bizProjectContractDetails.setSubjectUnit(bizContractDetailChangeInvalid.getSubjectUnit());
            bizProjectContractDetails.setCompleteAmount(bizContractDetailChangeInvalid.getCompleteAmount());
            bizProjectContractDetails.setPaidMoney(bizContractDetailChangeInvalid.getPaidMoney());
            bizProjectContractDetails.setSubjectAmount(bizContractDetailChangeInvalid.getSubjectAmount());
            bizProjectContractDetails.setSubjectMoney(bizContractDetailChangeInvalid.getSubjectMoney());
            bizProjectContractDetails.setRemarks(bizContractDetailChangeInvalid.getRemarks());
            bizProjectContractDetailsList.add(bizProjectContractDetails);
        }
        this.bizProjectContractManager.saveOrUpdate((Object)bizProjectContract);
        this.bizProjectContractDetailsManager.saveOrUpdateBatch(bizProjectContractDetailsList);
    }

    private void checkContractId(BizApplicationForChangeOfContract bizApplicationForChangeOfContract) {
        List list;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CONTRACT_ID_", (Object)bizApplicationForChangeOfContract.getContractId());
        queryWrapper.eq((Object)"is_dele_", (Object)"0");
        if (StringUtils.isNotBlank((CharSequence)bizApplicationForChangeOfContract.getId())) {
            queryWrapper.notIn((Object)"ID_", new Object[]{bizApplicationForChangeOfContract.getId()});
        }
        if ((list = ((BizApplicationForChangeOfContractDao)this.baseMapper).selectList((Wrapper)queryWrapper)).size() > 0) {
            throw new RuntimeException("\u8be5\u5408\u540c\u5df2\u7ecf\u4fee\u6539\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\uff01\uff01\uff01");
        }
    }
}

