/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class HtScriptTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HtScriptTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HtScriptTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ScriptTask", HtScriptTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ServiceTask.class, HtScriptTaskJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "ScriptTask";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ServiceTask serviceTask = (ServiceTask)baseElement;
        if ("mail".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("mailtaskto", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskfrom", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasksubject", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskbcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasktext", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskhtml", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcharset", serviceTask, propertiesNode);
        } else if ("camel".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("cameltaskcamelcontext", "camelContext", serviceTask, propertiesNode);
        } else if ("mule".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("muletaskendpointurl", "endpointUrl", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletasklanguage", "language", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskpayloadexpression", "payloadExpression", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskresultvariable", "resultVariable", serviceTask, propertiesNode);
        } else {
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskexpression", serviceTask.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskdelegateexpression", serviceTask.getImplementation());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
            this.addFieldExtensions(serviceTask.getFieldExtensions(), propertiesNode);
        }
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode itemsArrayNode;
        JsonNode fieldsNode;
        ServiceTask task = new ServiceTask();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            task.setImplementation(this.getPropertyValueAsString("servicetaskclass", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            task.setImplementation(this.getPropertyValueAsString("servicetaskexpression", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskdelegateexpression", elementNode))) {
            task.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            task.setImplementation(this.getPropertyValueAsString("servicetaskdelegateexpression", elementNode));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("servicetaskresultvariable", elementNode))) {
            task.setResultVariableName(this.getPropertyValueAsString("servicetaskresultvariable", elementNode));
        }
        if ((fieldsNode = this.getProperty("servicetaskfields", elementNode)) != null && (itemsArrayNode = fieldsNode.get("fields")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode nameNode = itemNode.get("name");
                if (nameNode == null || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                FieldExtension field = new FieldExtension();
                field.setFieldName(nameNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("stringValue", itemNode))) {
                    field.setStringValue(this.getValueAsString("stringValue", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("string", itemNode))) {
                    field.setStringValue(this.getValueAsString("string", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("expression", itemNode))) {
                    field.setExpression(this.getValueAsString("expression", itemNode));
                }
                task.getFieldExtensions().add(field);
            }
        }
        return task;
    }

    protected void setPropertyFieldValue(String name, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!name.substring(8).equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(name, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(name, extension.getExpression(), propertiesNode);
        }
    }

    protected void setPropertyFieldValue(String propertyName, String fieldName, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!fieldName.equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(propertyName, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(propertyName, extension.getExpression(), propertiesNode);
        }
    }
}

