/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.statistics.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.manager.BizCourseDetailsManager;
import com.artfess.yhxt.basedata.manager.BizCulvertInformationManager;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDataManager;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckData;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.statistics.dao.StatisticalStatementDao;
import com.artfess.yhxt.statistics.manager.StatisticalStatementManager;
import com.artfess.yhxt.statistics.vo.Circle;
import com.artfess.yhxt.statistics.vo.CountMaintenanceNew;
import com.artfess.yhxt.statistics.vo.CountStructureVo;
import com.artfess.yhxt.statistics.vo.DiseaseCategoryVo;
import com.artfess.yhxt.statistics.vo.DiseaseHandlingSituationVo;
import com.artfess.yhxt.statistics.vo.DiseasePositionVo;
import com.artfess.yhxt.statistics.vo.InspectForRoadSegment;
import com.artfess.yhxt.statistics.vo.MaintainMessageVo;
import com.artfess.yhxt.statistics.vo.MaintenanceEveryMoneyVo;
import com.artfess.yhxt.statistics.vo.MaintenanceNewVo;
import com.artfess.yhxt.statistics.vo.MaintenanceRoadMoneyVo;
import com.artfess.yhxt.statistics.vo.MaintenanceYearMoney;
import com.artfess.yhxt.statistics.vo.MqiDataVo;
import com.artfess.yhxt.statistics.vo.OrgMessageVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class StatisticalStatementManagerImpl
implements StatisticalStatementManager {
    @Resource
    StatisticalStatementDao statisticalStatementDao;
    @Resource
    BizCourseDetailsManager bizCourseDetailsManager;
    @Resource
    RoadManager roadManager;
    @Resource
    SiteInspectionManager siteInspectionManager;
    @Resource
    BridgeInformationManager bridgeInformationManager;
    @Resource
    TunnelInformationManager tunnelInformationManager;
    @Resource
    BizCulvertInformationManager culvertInformationManager;
    @Resource
    SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    BaseContext baseContext;
    @Resource
    OrgManager orgManager;
    @Resource
    OrgDao orgDao;
    @Resource
    BizMqiCheckDataManager bizMqiCheckDataManager;

    @Override
    public Map<String, Object> countDisease(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        DiseaseCategoryVo diseaseCategory = this.statisticalStatementDao.countDiseaseCategory(map);
        DiseaseHandlingSituationVo diseaseHandlingSituation = this.statisticalStatementDao.countDiseaseHandlingSituation(map);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PCODE_", (Object)"CBKM");
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = this.bizCourseDetailsManager.list((Wrapper)queryWrapper);
        HashMap subjectMap = new HashMap();
        list.forEach(s -> {
            Integer count = this.statisticalStatementDao.countDiseaseSubject(s.getSubjectCode(), map);
            subjectMap.put(s.getSubjectName(), count);
        });
        DiseasePositionVo diseasePosition = this.statisticalStatementDao.countPosition(map);
        hashMap.put("diseaseCategory", diseaseCategory);
        hashMap.put("diseaseHandlingSituation", diseaseHandlingSituation);
        hashMap.put("subject", subjectMap);
        hashMap.put("diseasePosition", diseasePosition);
        return hashMap;
    }

    @Override
    public Map<String, Object> countMaintenance(Map<String, Object> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PCODE_", (Object)"CBKM");
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List listPcode = this.bizCourseDetailsManager.list((Wrapper)queryWrapper);
        List subjectCodes = this.bizCourseDetailsManager.list((Wrapper)new QueryWrapper().in((Object)"PCODE_", (Collection)listPcode.stream().map(BizCourseDetails::getSubjectCode).collect(Collectors.toList())));
        ArrayList<MaintenanceEveryMoneyVo> courseDetails = new ArrayList<MaintenanceEveryMoneyVo>();
        List<MaintenanceEveryMoneyVo> mapList = this.statisticalStatementDao.countMaintenanceEveryMoney(map);
        subjectCodes.forEach(s -> {
            MaintenanceEveryMoneyVo maintenanceEveryMoneyVo = new MaintenanceEveryMoneyVo();
            maintenanceEveryMoneyVo.setPcode(s.getPcode());
            maintenanceEveryMoneyVo.setPname(s.getPname());
            maintenanceEveryMoneyVo.setSubjectCode(s.getSubjectCode());
            maintenanceEveryMoneyVo.setSubjectName(s.getSubjectName());
            courseDetails.add(maintenanceEveryMoneyVo);
        });
        courseDetails.forEach(s -> mapList.forEach(x -> {
            if (s.getPcode().equals(x.getPcode()) && s.getSubjectCode().equals(x.getSubjectCode())) {
                s.setEveryMoney(x.getEveryMoney());
            }
        }));
        List<MaintenanceYearMoney> maintenanceYearMonies = this.statisticalStatementDao.countMaintenanceYearMoney(map);
        QueryWrapper queryWrapperRoad = new QueryWrapper();
        queryWrapperRoad.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapperRoad.eq(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", map.get("roadSegmentId"));
        List listRoad = this.roadManager.list((Wrapper)queryWrapperRoad);
        List<MaintenanceRoadMoneyVo> maintenanceRoadMoneyVos = this.statisticalStatementDao.countMaintenanceRoadMoney(map);
        ArrayList<MaintenanceRoadMoneyVo> moneyVos = new ArrayList<MaintenanceRoadMoneyVo>();
        listRoad.forEach(s -> {
            MaintenanceRoadMoneyVo maintenanceRoadMoneyVo = new MaintenanceRoadMoneyVo();
            maintenanceRoadMoneyVo.setRoadSegmentId(s.getId());
            maintenanceRoadMoneyVo.setRoadSegmentName(s.getName());
            moneyVos.add(maintenanceRoadMoneyVo);
        });
        moneyVos.forEach(s -> maintenanceRoadMoneyVos.forEach(x -> {
            if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                s.setTotalMoney(x.getTotalMoney());
            }
        }));
        resultMap.put("courseDetails", courseDetails);
        resultMap.put("maintenanceYearMonies", maintenanceYearMonies);
        resultMap.put("MaintenanceRoadMoney", moneyVos);
        return resultMap;
    }

    @Override
    public Map<String, Object> countSiteDaily(Map<String, Object> map) {
        QueryWrapper siteInspectionQueryWrapper = new QueryWrapper();
        siteInspectionQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        siteInspectionQueryWrapper.ge(ObjectUtils.isNotEmpty((Object)map.get("startTime")), (Object)"PATROL_DATE_", map.get("startTime"));
        siteInspectionQueryWrapper.le(ObjectUtils.isNotEmpty((Object)map.get("endTime")), (Object)"PATROL_DATE_", map.get("endTime"));
        if (null != map.get("roadSegmentId")) {
            List<String> roadSegmentIds = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            siteInspectionQueryWrapper.in((Object)"ROAD_SEGMENT_ID_", roadSegmentIds);
        }
        List siteInspectionList = this.siteInspectionManager.list((Wrapper)siteInspectionQueryWrapper);
        int countSiteDailyFinish = 0;
        int countSiteDailyUnFinish = 0;
        for (SiteInspection s2 : siteInspectionList) {
            if (null != s2.getType() && null != s2.getHandStatus() && s2.getType() == 1 && "1".equals(s2.getHandStatus())) {
                ++countSiteDailyFinish;
            }
            if (null == s2.getType() || s2.getType() != 1) continue;
            ++countSiteDailyUnFinish;
        }
        ArrayList<Circle> circles = new ArrayList<Circle>();
        Circle circle = new Circle();
        circle.setName("\u5e94\u5de1\u68c0");
        circle.setValue(String.valueOf(countSiteDailyFinish));
        circles.add(circle);
        Circle cir = new Circle();
        cir.setName("\u5b9e\u9645\u5de1\u68c0");
        cir.setValue(String.valueOf(countSiteDailyUnFinish));
        circles.add(cir);
        ArrayList inspectForRoadSegments = new ArrayList();
        List<InspectForRoadSegment> inspectForRoadSegmentList = this.statisticalStatementDao.countSiteDaily(map);
        QueryWrapper queryWrapperRoad = new QueryWrapper();
        queryWrapperRoad.eq((Object)"IS_DELE_", (Object)"0");
        if (null != map.get("roadSegmentId")) {
            List<String> roadSegmentIds = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            queryWrapperRoad.in((Object)"id_", roadSegmentIds);
        }
        List listRoad = this.roadManager.list((Wrapper)queryWrapperRoad);
        listRoad.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        inspectForRoadSegments.forEach(s -> inspectForRoadSegmentList.forEach(x -> {
            if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                s.setValueFinish(x.getValueFinish());
                s.setValueUnFinish(x.getValueUnFinish());
            }
        }));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countSiteNight(Map<String, Object> map) {
        QueryWrapper siteInspectionQueryWrapper = new QueryWrapper();
        siteInspectionQueryWrapper.eq((Object)"IS_DELE_", (Object)0);
        siteInspectionQueryWrapper.ge(ObjectUtils.isNotEmpty((Object)map.get("startTime")), (Object)"PATROL_DATE_", map.get("startTime"));
        siteInspectionQueryWrapper.le(ObjectUtils.isNotEmpty((Object)map.get("endTime")), (Object)"PATROL_DATE_", map.get("endTime"));
        siteInspectionQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"ROAD_SEGMENT_ID_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List siteInspectionList = this.siteInspectionManager.list((Wrapper)siteInspectionQueryWrapper);
        long countSiteDailyFinish = siteInspectionList.stream().filter(s -> s.getType() == 2).filter(s -> "1".equals(s.getHandStatus())).count();
        long countSiteDailyUnFinish = siteInspectionList.stream().filter(s -> s.getType() == 2).count();
        ArrayList<Circle> circles = new ArrayList<Circle>();
        Circle circle = new Circle();
        circle.setName("\u5e94\u5de1\u68c0");
        circle.setValue(String.valueOf(countSiteDailyFinish));
        circles.add(circle);
        Circle cir = new Circle();
        cir.setName("\u5b9e\u9645\u5de1\u68c0");
        cir.setValue(String.valueOf(countSiteDailyUnFinish));
        circles.add(cir);
        ArrayList inspectForRoadSegments = new ArrayList();
        List<InspectForRoadSegment> inspectForRoadSegmentList = this.statisticalStatementDao.countSiteNight(map);
        QueryWrapper queryWrapperRoad = new QueryWrapper();
        queryWrapperRoad.eq((Object)"IS_DELE_", (Object)"0");
        queryWrapperRoad.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List listRoad = this.roadManager.list((Wrapper)queryWrapperRoad);
        listRoad.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        inspectForRoadSegments.forEach(s -> inspectForRoadSegmentList.forEach(x -> {
            if (s.getRoadSegmentId().equals(x.getRoadSegmentId())) {
                s.setValueFinish(x.getValueFinish());
                s.setValueUnFinish(x.getValueUnFinish());
            }
        }));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countBridgeCheck(Map<String, Object> map) {
        Circle circle;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        ArrayList inspectForRoadSegments = new ArrayList();
        QueryWrapper roadQueryWrapper = new QueryWrapper();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List roadList = this.roadManager.list((Wrapper)roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper bridgeQueryWrapper = new QueryWrapper();
        bridgeQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        bridgeQueryWrapper.in(roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List list = this.bridgeInformationManager.list((Wrapper)bridgeQueryWrapper);
        Object accDateYear = map.get("accDateYear");
        Object accDateMonth = map.get("accDateMonth");
        if (ObjectUtils.isEmpty((Object)accDateYear)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5e74\u4efd");
        }
        if (ObjectUtils.isEmpty((Object)accDateMonth)) {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(12 * list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> bridgeId = list.stream().map(BridgeInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countBridgeCheckYear(map, bridgeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BridgeInformation>> collect = list.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BridgeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<BridgeInformation> bridgeInformationList = entry.getValue();
                    List<String> bridgeGroupId = bridgeInformationList.stream().map(BridgeInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countBridgeCheckYear(map, bridgeGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * bridgeInformationList.size()));
                }
            }
        } else {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> bridgeId = list.stream().map(BridgeInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countBridgeCheckMouth(map, bridgeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BridgeInformation>> collect = list.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BridgeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<BridgeInformation> bridgeInformationList = entry.getValue();
                    List<String> bridgeGroupId = bridgeInformationList.stream().map(BridgeInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countBridgeCheckMouth(map, bridgeGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * bridgeInformationList.size()));
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countReportBridge(Map<String, Object> map) {
        if (ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId"))) {
            List<String> ids = Arrays.asList(map.get("roadSegmentId").toString().split(","));
            map.put("ids", ids);
        }
        List<Map<String, Object>> bridgeType = this.statisticalStatementDao.countBridgeType(map);
        List<Map<String, Object>> bridgeShapeType = this.statisticalStatementDao.countBridgeShapeType(map);
        List<Map<String, Object>> bridgeCategory = this.statisticalStatementDao.countBridgeCategory(map);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("bridgeType", bridgeType);
        hashMap.put("bridgeShapeType", bridgeShapeType);
        hashMap.put("category", bridgeCategory);
        return hashMap;
    }

    @Override
    public HSSFWorkbook exportBridge(HttpServletResponse response, Map<String, Object> map) {
        try {
            List<Map<String, Object>> bridgeCategory = this.statisticalStatementDao.countBridgeCategory(map);
            LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
            exportMap.put("shapeTypeValue", "\u4e0a\u90e8\u7ed3\u6784\u540d\u79f0");
            exportMap.put("shapeTypeCount", "\u6570\u91cf");
            exportMap.put("length", "\u5355\u4f4d\u603b\u957f(m)");
            List collect = bridgeCategory.stream().map(s -> {
                HashMap hashMap = new HashMap();
                hashMap.put("shapeTypeValue", s.get("categoryValue"));
                hashMap.put("shapeTypeCount", s.get("categoryCount"));
                hashMap.put("length", s.get("length"));
                return hashMap;
            }).collect(Collectors.toList());
            return ExcelUtil.exportExcel((String)"\u6865\u6881\u7ed3\u6784", (int)10, exportMap, collect);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @Override
    public List<MaintainMessageVo> maintainMessage(Map<String, Object> map) {
        ArrayList<MaintainMessageVo> maintainMessageVos = new ArrayList<MaintainMessageVo>();
        BigDecimal decimalAll = new BigDecimal(2);
        QueryWrapper roadQueryWrapper = new QueryWrapper();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"ID_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        roadQueryWrapper.like(StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()), (Object)"COMPANY_IDS_", (Object)this.baseContext.getCurrentOrgId());
        List roadList = this.roadManager.list((Wrapper)roadQueryWrapper);
        roadList.forEach(s -> {
            MaintainMessageVo messageVo = new MaintainMessageVo();
            Org org = this.getPrentId(s.getCompanyId());
            if (org != null) {
                messageVo.setOrgId(org.getId());
                messageVo.setOrgName(org.getName());
            }
            messageVo.setId(UUID.randomUUID().toString());
            messageVo.setCompanyId(s.getCompanyId());
            messageVo.setCompanyName(s.getCompanyName());
            messageVo.setRoadSegmentId(s.getId());
            messageVo.setRoadSegmentName(s.getName());
            if (s.getLength() != null) {
                messageVo.setRoadLength(new BigDecimal(s.getLength().floatValue()).setScale(2, 4));
            }
            if (s.getWidth() != null) {
                messageVo.setRoadWidth(new BigDecimal(s.getWidth().floatValue()));
            }
            messageVo.setStartPegK(s.getStartPegK());
            messageVo.setEndPegK(s.getEndPegK());
            maintainMessageVos.add(messageVo);
        });
        QueryWrapper bridgeQueryWrapper = new QueryWrapper();
        bridgeQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", (Collection)roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List bridgeInformationList = this.bridgeInformationManager.list((Wrapper)bridgeQueryWrapper);
        Map<String, List<BridgeInformation>> collectBridge = bridgeInformationList.stream().collect(Collectors.groupingBy(BridgeInformation::getRoadSegmentId));
        for (Map.Entry<String, List<BridgeInformation>> entry : collectBridge.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (!maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) continue;
                List<BridgeInformation> list = collectBridge.get(entry.getKey());
                maintainMessageVo.setBridgeCount(list.size());
                double bridgeSum = list.stream().mapToDouble(BridgeInformation::getLength).sum();
                BigDecimal bigDecimal = new BigDecimal(bridgeSum);
                BigDecimal bridgeLinearMeter = bigDecimal.setScale(2, 4);
                BigDecimal bigDecimal2 = bridgeLinearMeter.divide(decimalAll);
                maintainMessageVo.setBridgeLinearMeter(bridgeLinearMeter);
                maintainMessageVo.setBridgeSingleCount(bigDecimal2);
                long l = list.stream().filter(s -> "1".equals(s.getType())).count();
                double extraBigBridgeLinearMeterSum = list.stream().filter(s -> "1".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                BigDecimal extraBigBridgeLinearMeterBigDecimal = new BigDecimal(extraBigBridgeLinearMeterSum);
                BigDecimal extraBigBridgeLinearMeter = extraBigBridgeLinearMeterBigDecimal.setScale(2, 4);
                BigDecimal extraBigBridgeSingleCount = extraBigBridgeLinearMeter.divide(decimalAll);
                maintainMessageVo.setExtraBigBridgeCount(Integer.parseInt(String.valueOf(l)));
                maintainMessageVo.setExtraBigBridgeLinearMeter(extraBigBridgeLinearMeter);
                maintainMessageVo.setExtraBigBridgeSingleCount(extraBigBridgeSingleCount);
                long bigBridgeCount = list.stream().filter(s -> "2".equals(s.getType())).count();
                double bigSum = list.stream().filter(s -> "2".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                BigDecimal decimal = new BigDecimal(bigSum);
                BigDecimal bigBridgeLinearMeter = decimal.setScale(2, 4);
                BigDecimal bigBridgeSingleCount = bigBridgeLinearMeter.divide(decimalAll);
                maintainMessageVo.setBigBridgeCount(Integer.parseInt(String.valueOf(bigBridgeCount)));
                maintainMessageVo.setBigBridgeSingleCount(bigBridgeSingleCount);
                maintainMessageVo.setBigBridgeLinearMeter(bigBridgeLinearMeter);
                long middleBridgeCount = list.stream().filter(s -> "3".equals(s.getType())).count();
                double middleSum = list.stream().filter(s -> "3".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                BigDecimal middleSumDecimal = new BigDecimal(middleSum);
                BigDecimal middleBridgeLinearMeter = middleSumDecimal.setScale(2, 4);
                BigDecimal middleBridgeSingleCount = middleBridgeLinearMeter.divide(decimalAll);
                maintainMessageVo.setMiddleBridgeCount(Integer.parseInt(String.valueOf(middleBridgeCount)));
                maintainMessageVo.setMiddleBridgeLinearMeter(middleBridgeLinearMeter);
                maintainMessageVo.setMiddleBridgeSingleCount(middleBridgeSingleCount);
                long smallBridgeCount = list.stream().filter(s -> "4".equals(s.getType())).count();
                double smallBridgeSum = list.stream().filter(s -> "4".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
                BigDecimal smallBridgeBigDecimal = new BigDecimal(smallBridgeSum);
                BigDecimal smallBridgeLinearMeter = smallBridgeBigDecimal.setScale(2, 4);
                BigDecimal smallBridgeSingleCount = smallBridgeLinearMeter.divide(decimalAll);
                maintainMessageVo.setSmallBridgeCount(Integer.parseInt(String.valueOf(smallBridgeCount)));
                maintainMessageVo.setSmallBridgeLinearMeter(smallBridgeLinearMeter);
                maintainMessageVo.setSmallBridgeSingleCount(smallBridgeSingleCount);
            }
        }
        QueryWrapper tunnelQueryWrapper = new QueryWrapper();
        tunnelQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", (Collection)roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List tunnelInformationList = this.tunnelInformationManager.list((Wrapper)tunnelQueryWrapper);
        Map<String, List<TunnelInformation>> collectTunnel = tunnelInformationList.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));
        for (Map.Entry<String, List<TunnelInformation>> entry : collectTunnel.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (!maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) continue;
                List<TunnelInformation> list = collectTunnel.get(entry.getKey());
                maintainMessageVo.setTunnelCount(Integer.parseInt(String.valueOf(list.size())));
                double tunnelSum = list.stream().mapToDouble(TunnelInformation::getLength).sum();
                BigDecimal bigDecimal = new BigDecimal(tunnelSum);
                BigDecimal tunnelLinearMeter = bigDecimal.setScale(2, 4);
                BigDecimal tunnelSingleCount = tunnelLinearMeter.divide(decimalAll);
                maintainMessageVo.setTunnelSingleCount(tunnelSingleCount);
                maintainMessageVo.setTunnelLinearMeter(tunnelLinearMeter);
                long extraBigTunnelCount = list.stream().filter(s -> "1".equals(s.getType())).count();
                double extraBigSum = list.stream().filter(s -> "1".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                BigDecimal extraBigBigDecimal = new BigDecimal(extraBigSum);
                BigDecimal extraBigTunnelLinearMeter = extraBigBigDecimal.setScale(2, 4);
                BigDecimal extraBigTunnelSingleCount = extraBigTunnelLinearMeter.divide(decimalAll);
                maintainMessageVo.setExtraBigTunnelCount(Integer.parseInt(String.valueOf(extraBigTunnelCount)));
                maintainMessageVo.setExtraBigTunnelSingleCount(extraBigTunnelSingleCount);
                maintainMessageVo.setExtraBigTunnelLinearMeter(extraBigTunnelLinearMeter);
                long bigTunnelCount = list.stream().filter(s -> "2".equals(s.getType())).count();
                double bigTunnelSum = list.stream().filter(s -> "2".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                BigDecimal bigTunnelBigDecimal = new BigDecimal(bigTunnelSum);
                BigDecimal bigTunnelLinearMeter = bigTunnelBigDecimal.setScale(2, 4);
                BigDecimal bigTunnelSingleCount = bigTunnelLinearMeter.divide(decimalAll);
                maintainMessageVo.setBigTunnelCount(Integer.parseInt(String.valueOf(bigTunnelCount)));
                maintainMessageVo.setBigTunnelSingleCount(bigTunnelSingleCount);
                maintainMessageVo.setBigTunnelLinearMeter(bigTunnelLinearMeter);
                long middleTunnelCount = list.stream().filter(s -> "3".equals(s.getType())).count();
                double middleTunnelSum = list.stream().filter(s -> "3".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                BigDecimal middleTunnelBigDecimal = new BigDecimal(middleTunnelSum);
                BigDecimal middleTunnelLinearMeter = middleTunnelBigDecimal.setScale(2, 4);
                BigDecimal middleTunnelSingleCount = middleTunnelLinearMeter.divide(decimalAll);
                maintainMessageVo.setMiddleTunnelCount(Integer.parseInt(String.valueOf(middleTunnelCount)));
                maintainMessageVo.setMiddleTunnelSingleCount(middleTunnelSingleCount);
                maintainMessageVo.setMiddleTunnelLinearMeter(middleTunnelLinearMeter);
                long smallTunnelCount = list.stream().filter(s -> "4".equals(s.getType())).count();
                double smallTunnelCountSum = list.stream().filter(s -> "4".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
                BigDecimal smallTunnelCountBigDecimal = new BigDecimal(smallTunnelCountSum);
                BigDecimal smallTunnelCountLinearMeter = smallTunnelCountBigDecimal.setScale(2, 4);
                BigDecimal smallTunnelCountSingleCount = smallTunnelCountLinearMeter.divide(decimalAll);
                maintainMessageVo.setSmallTunnelCount(Integer.parseInt(String.valueOf(smallTunnelCount)));
                maintainMessageVo.setSmallTunnelSingleCount(smallTunnelCountSingleCount);
                maintainMessageVo.setSmallTunnelLinearMeter(smallTunnelCountLinearMeter);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", (Collection)roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List list = this.culvertInformationManager.list((Wrapper)queryWrapper);
        Map<String, List<BizCulvertInformation>> culvertCollect = list.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
        for (Map.Entry<String, List<BizCulvertInformation>> entry : culvertCollect.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (!maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) continue;
                List<BizCulvertInformation> list2 = culvertCollect.get(entry.getKey());
                maintainMessageVo.setCulvertCount(Integer.parseInt(String.valueOf(list2.size())));
            }
        }
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", (Collection)roadList.stream().map(Road::getId).collect(Collectors.toList()));
        List list3 = this.sideSlopeInformationManager.list((Wrapper)queryWrapper2);
        Map<String, List<SideSlopeInformation>> slopeCollect = list3.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
        for (Map.Entry<String, List<SideSlopeInformation>> entry : slopeCollect.entrySet()) {
            for (MaintainMessageVo maintainMessageVo : maintainMessageVos) {
                if (!maintainMessageVo.getRoadSegmentId().equals(entry.getKey())) continue;
                List<SideSlopeInformation> sideSlopeList = slopeCollect.get(entry.getKey());
                maintainMessageVo.setSideSlopeCount(Integer.parseInt(String.valueOf(sideSlopeList.size())));
            }
        }
        Map<String, List<MaintainMessageVo>> map2 = maintainMessageVos.stream().collect(Collectors.groupingBy(MaintainMessageVo::getCompanyId));
        for (Map.Entry<String, List<MaintainMessageVo>> entry : map2.entrySet()) {
            List<MaintainMessageVo> messageVos = map2.get(entry.getKey());
            MaintainMessageVo maintainMessageVo = new MaintainMessageVo();
            MaintainMessageVo vo = messageVos.get(0);
            maintainMessageVo.setId(UUID.randomUUID().toString());
            maintainMessageVo.setOrgId(vo.getOrgId());
            maintainMessageVo.setOrgName(vo.getOrgName());
            maintainMessageVo.setCompanyId(entry.getKey());
            maintainMessageVo.setCompanyName(vo.getCompanyName());
            maintainMessageVo.setRoadSegmentName("\u5c0f\u8ba1");
            maintainMessageVo.setRoadLength(messageVos.stream().map(MaintainMessageVo::getRoadLength).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setRoadWidth(messageVos.stream().map(MaintainMessageVo::getRoadWidth).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getBridgeCount).sum());
            maintainMessageVo.setBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setExtraBigBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getExtraBigBridgeCount).sum());
            maintainMessageVo.setExtraBigBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getExtraBigBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setExtraBigBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getExtraBigBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBigBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getBigBridgeCount).sum());
            maintainMessageVo.setBigBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getBigBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBigBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getBigBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setMiddleBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getMiddleBridgeCount).sum());
            maintainMessageVo.setMiddleBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getMiddleBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setMiddleBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getMiddleBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setSmallBridgeCount(messageVos.stream().mapToInt(MaintainMessageVo::getSmallBridgeCount).sum());
            maintainMessageVo.setSmallBridgeSingleCount(messageVos.stream().map(MaintainMessageVo::getSmallBridgeSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setSmallBridgeLinearMeter(messageVos.stream().map(MaintainMessageVo::getSmallBridgeLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getTunnelCount).sum());
            maintainMessageVo.setTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setExtraBigTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getExtraBigTunnelCount).sum());
            maintainMessageVo.setExtraBigTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getExtraBigTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setExtraBigTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getExtraBigTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBigTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getBigTunnelCount).sum());
            maintainMessageVo.setBigTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getBigTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setBigTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getBigTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setMiddleTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getMiddleTunnelCount).sum());
            maintainMessageVo.setMiddleTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getMiddleTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setMiddleTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getMiddleTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setSmallTunnelCount(messageVos.stream().mapToInt(MaintainMessageVo::getSmallTunnelCount).sum());
            maintainMessageVo.setSmallTunnelSingleCount(messageVos.stream().map(MaintainMessageVo::getSmallTunnelSingleCount).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setSmallTunnelLinearMeter(messageVos.stream().map(MaintainMessageVo::getSmallTunnelLinearMeter).reduce(BigDecimal.ZERO, BigDecimal::add));
            maintainMessageVo.setCulvertCount(messageVos.stream().mapToInt(MaintainMessageVo::getCulvertCount).sum());
            maintainMessageVo.setSideSlopeCount(messageVos.stream().mapToInt(MaintainMessageVo::getSideSlopeCount).sum());
            maintainMessageVos.add(maintainMessageVo);
        }
        return maintainMessageVos.stream().sorted(Comparator.comparing(MaintainMessageVo::getOrgName)).sorted(Comparator.comparing(MaintainMessageVo::getCompanyName)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> countTunnelCheck(Map<String, Object> map) {
        Circle circle;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        ArrayList inspectForRoadSegments = new ArrayList();
        QueryWrapper roadQueryWrapper = new QueryWrapper();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List roadList = this.roadManager.list((Wrapper)roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper tunnelQueryWrapper = new QueryWrapper();
        tunnelQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        tunnelQueryWrapper.in(roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List list = this.tunnelInformationManager.list((Wrapper)tunnelQueryWrapper);
        Object accDateYear = map.get("accDateYear");
        Object accDateMonth = map.get("accDateMonth");
        if (ObjectUtils.isEmpty((Object)accDateYear)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5e74\u4efd");
        }
        if (ObjectUtils.isEmpty((Object)accDateMonth)) {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(12 * list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> tunnelId = list.stream().map(TunnelInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countTunnelCheckYear(map, tunnelId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<TunnelInformation>> collect = list.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));
            for (Map.Entry<String, List<TunnelInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<TunnelInformation> tunnelInformationList = entry.getValue();
                    List<String> tunnelGroupId = tunnelInformationList.stream().map(TunnelInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countTunnelCheckYear(map, tunnelGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(tunnelInformationList.size()));
                }
            }
        } else {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> tunnelId = list.stream().map(TunnelInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countTunnelCheckMouth(map, tunnelId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<TunnelInformation>> collect = list.stream().collect(Collectors.groupingBy(TunnelInformation::getRoadSegmentId));
            for (Map.Entry<String, List<TunnelInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<TunnelInformation> tunnelInformationList = entry.getValue();
                    List<String> tunnelGroupId = tunnelInformationList.stream().map(TunnelInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countTunnelCheckMouth(map, tunnelGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(tunnelInformationList.size()));
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countSideSlopCheck(Map<String, Object> map) {
        Circle circle;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        ArrayList inspectForRoadSegments = new ArrayList();
        QueryWrapper roadQueryWrapper = new QueryWrapper();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List roadList = this.roadManager.list((Wrapper)roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper sideSlopeQueryWrapper = new QueryWrapper();
        sideSlopeQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        sideSlopeQueryWrapper.in(roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List list = this.sideSlopeInformationManager.list((Wrapper)sideSlopeQueryWrapper);
        Object accDateYear = map.get("accDateYear");
        Object accDateMonth = map.get("accDateMonth");
        if (ObjectUtils.isEmpty((Object)accDateYear)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5e74\u4efd");
        }
        if (ObjectUtils.isEmpty((Object)accDateMonth)) {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(12 * list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> sideSlopeId = list.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countSideSlopeCheckYear(map, sideSlopeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<SideSlopeInformation>> collect = list.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<SideSlopeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<SideSlopeInformation> sideSlopeInformationList = entry.getValue();
                    List<String> sideSlopeGroupId = sideSlopeInformationList.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countSideSlopeCheckYear(map, sideSlopeGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(12 * sideSlopeInformationList.size()));
                }
            }
        } else {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> sideSlopeId = list.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countSideSlopeCheckMouth(map, sideSlopeId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<SideSlopeInformation>> collect = list.stream().collect(Collectors.groupingBy(SideSlopeInformation::getRoadSegmentId));
            for (Map.Entry<String, List<SideSlopeInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<SideSlopeInformation> sideSlopeInformationList = entry.getValue();
                    List<String> sideSlopeGroupId = sideSlopeInformationList.stream().map(SideSlopeInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countSideSlopeCheckMouth(map, sideSlopeGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(sideSlopeInformationList.size()));
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public Map<String, Object> countCulvertCheck(Map<String, Object> map) {
        Circle circle;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        ArrayList inspectForRoadSegments = new ArrayList();
        QueryWrapper roadQueryWrapper = new QueryWrapper();
        roadQueryWrapper.in(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"id_", Arrays.asList(map.get("roadSegmentId").toString().split(",")));
        List roadList = this.roadManager.list((Wrapper)roadQueryWrapper);
        roadList.forEach(s -> {
            InspectForRoadSegment inspectForRoadSegment = new InspectForRoadSegment();
            inspectForRoadSegment.setRoadSegmentId(s.getId());
            inspectForRoadSegment.setRoadSegmentName(s.getName());
            inspectForRoadSegments.add(inspectForRoadSegment);
        });
        String roadIds = roadList.stream().map(Road::getId).collect(Collectors.joining(","));
        QueryWrapper culvertQueryWrapper = new QueryWrapper();
        culvertQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        culvertQueryWrapper.in(roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", Arrays.asList(roadIds.split(",")));
        List list = this.culvertInformationManager.list((Wrapper)culvertQueryWrapper);
        Object accDateYear = map.get("accDateYear");
        if (ObjectUtils.isEmpty((Object)accDateYear)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5e74\u4efd");
        }
        if (ObjectUtils.isEmpty((Object)map.get("startTime")) && ObjectUtils.isEmpty((Object)map.get("endTime"))) {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(4 * list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> culvertId = list.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countCulvertCheckYear(map, culvertId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BizCulvertInformation>> collect = list.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BizCulvertInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<BizCulvertInformation> culvertInformationList = entry.getValue();
                    List<String> culvertGroupId = culvertInformationList.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countCulvertCheckYear(map, culvertGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(4 * culvertInformationList.size()));
                }
            }
        } else {
            circle = new Circle();
            circle.setName("\u5e94\u5de1\u68c0");
            circle.setValue(String.valueOf(list.size()));
            Circle circle2 = new Circle();
            circle2.setName("\u5b9e\u9645\u5de1\u68c0");
            List<String> culvertId = list.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
            Integer integer = this.statisticalStatementDao.countCulvertCheckMouth(map, culvertId);
            circle2.setValue(String.valueOf(integer));
            circles.add(circle);
            circles.add(circle2);
            Map<String, List<BizCulvertInformation>> collect = list.stream().collect(Collectors.groupingBy(BizCulvertInformation::getRoadSegmentId));
            for (Map.Entry<String, List<BizCulvertInformation>> entry : collect.entrySet()) {
                for (InspectForRoadSegment inspectForRoadSegment : inspectForRoadSegments) {
                    if (!entry.getKey().equals(inspectForRoadSegment.getRoadSegmentId())) continue;
                    List<BizCulvertInformation> culvertInformationList = entry.getValue();
                    List<String> culvertGroupId = culvertInformationList.stream().map(BizCulvertInformation::getId).collect(Collectors.toList());
                    Integer valueUnFinishInteger = this.statisticalStatementDao.countCulvertCheckMouth(map, culvertGroupId);
                    inspectForRoadSegment.setValueFinish(String.valueOf(valueUnFinishInteger));
                    inspectForRoadSegment.setValueUnFinish(String.valueOf(culvertInformationList.size()));
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("circles", circles);
        hashMap.put("inspectForRoadSegments", inspectForRoadSegments);
        return hashMap;
    }

    @Override
    public List<MqiDataVo> countMqiReport(Map<String, Object> map) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(ObjectUtils.isNotEmpty((Object)map.get("roadSegmentId")), (Object)"ROAD_SEGMENT_ID_", map.get("roadSegmentId"));
        queryWrapper.eq(ObjectUtils.isNotEmpty((Object)map.get("year")), (Object)"YEAR_", map.get("year"));
        ArrayList<MqiDataVo> vos = new ArrayList<MqiDataVo>();
        List list = this.bizMqiCheckDataManager.list((Wrapper)queryWrapper);
        Map<String, List<BizMqiCheckData>> collect = list.stream().collect(Collectors.groupingBy(BizMqiCheckData::getLane));
        for (Map.Entry<String, List<BizMqiCheckData>> entry : collect.entrySet()) {
            MqiDataVo mqiDataVo = new MqiDataVo();
            List<BizMqiCheckData> bizMqiCheckData = entry.getValue();
            BizMqiCheckData checkData = bizMqiCheckData.get(0);
            mqiDataVo.setLane(checkData.getLane());
            mqiDataVo.setLaneValue(checkData.getLaneValue());
            List<String> bizMqiCheckDataIds = bizMqiCheckData.stream().map(BizMqiCheckData::getId).collect(Collectors.toList());
            Float mqiAvg = this.statisticalStatementDao.countMqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setMqiAvg(mqiAvg);
            Float pqiAvg = this.statisticalStatementDao.countPqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPqiAvg(pqiAvg);
            Float pciAvg = this.statisticalStatementDao.countPciAvg(bizMqiCheckDataIds);
            mqiDataVo.setPciAvg(pciAvg);
            Float rqiAvg = this.statisticalStatementDao.countRqiAvg(bizMqiCheckDataIds);
            mqiDataVo.setRqiAvg(rqiAvg);
            Float rdiAvg = this.statisticalStatementDao.countRdiAvg(bizMqiCheckDataIds);
            mqiDataVo.setRdiAvg(rdiAvg);
            Float pbiAvg = this.statisticalStatementDao.countPbiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPbiAvg(pbiAvg);
            Float sriAvg = this.statisticalStatementDao.countSriAvg(bizMqiCheckDataIds);
            mqiDataVo.setSriAvg(sriAvg);
            Float sciAvg = this.statisticalStatementDao.countSciAvg(bizMqiCheckDataIds);
            mqiDataVo.setSciAvg(sciAvg);
            Float bciAvg = this.statisticalStatementDao.countBciAvg(bizMqiCheckDataIds);
            mqiDataVo.setBciAvg(bciAvg);
            Float tciAvg = this.statisticalStatementDao.countTciAvg(bizMqiCheckDataIds);
            mqiDataVo.setTciAvg(tciAvg);
            Float pwiAvg = this.statisticalStatementDao.countPwiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPwiAvg(pwiAvg);
            Float pssiAvg = this.statisticalStatementDao.countPssiAvg(bizMqiCheckDataIds);
            mqiDataVo.setPssiAvg(pssiAvg);
            vos.add(mqiDataVo);
        }
        return vos;
    }

    @Override
    public List<CountStructureVo> countStructure(Map<String, Object> map) {
        List<CountStructureVo> countStructureVos = this.statisticalStatementDao.countStructure(map);
        return countStructureVos;
    }

    @Override
    public Map<String, Object> countMaintenanceNew(Map<String, Object> map) {
        if (ObjectUtils.isEmpty((Object)map.get("roadSegmentId"))) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8def\u6bb5");
        }
        ArrayList<MaintenanceNewVo> maintenanceNewVos = new ArrayList<MaintenanceNewVo>();
        String roadSegmentId = map.get("roadSegmentId").toString();
        List<String> ids = Arrays.asList(map.get("roadSegmentId").toString().split(","));
        map.put("ids", ids);
        List<BizCourseDetails> bizCourseDetailsRoad = this.bizCourseDetailsManager.getByParentIdRoad("", roadSegmentId);
        if (CollectionUtils.isEmpty(bizCourseDetailsRoad)) {
            List<BizCourseDetails> bizCourseDetails = this.bizCourseDetailsManager.getByParentIdRoad("CBKM", "");
            if (CollectionUtils.isNotEmpty(bizCourseDetails)) {
                this.countMaintence(map, maintenanceNewVos, bizCourseDetails);
            }
        } else {
            List<BizCourseDetails> bizCourseDetailsRoadPareant = this.bizCourseDetailsManager.getByParentIdRoad(bizCourseDetailsRoad.get(0).getSubjectCode(), roadSegmentId);
            if (CollectionUtils.isNotEmpty(bizCourseDetailsRoadPareant)) {
                this.countMaintence(map, maintenanceNewVos, bizCourseDetailsRoadPareant);
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("maintenanceNewVos", maintenanceNewVos);
        return resultMap;
    }

    private void countMaintence(Map<String, Object> map, List<MaintenanceNewVo> maintenanceNewVos, List<BizCourseDetails> bizCourseDetailsRoadPareant) {
        List<CountMaintenanceNew> countMaintenanceNews = this.statisticalStatementDao.countMaintenanceNew(map);
        countMaintenanceNews.forEach(s -> {
            String[] split;
            if (StringUtils.isNotEmpty((CharSequence)s.getSubjectNames()) && (split = s.getSubjectNames().split(",")).length > 0) {
                s.setSubjectNames(split[0]);
            }
        });
        Map<String, List<CountMaintenanceNew>> listMap = countMaintenanceNews.stream().collect(Collectors.groupingBy(CountMaintenanceNew::getSubjectNames));
        for (BizCourseDetails bizCourseDetails : bizCourseDetailsRoadPareant) {
            MaintenanceNewVo vo = new MaintenanceNewVo();
            vo.setPcode(bizCourseDetails.getSubjectCode());
            vo.setPname(bizCourseDetails.getSubjectName());
            maintenanceNewVos.add(vo);
        }
        for (String key : listMap.keySet()) {
            for (MaintenanceNewVo vo : maintenanceNewVos) {
                if (!vo.getPname().equals(key)) continue;
                vo.setPnameCount(String.valueOf(listMap.get(key).size()));
                String collect = listMap.get(key).stream().map(CountMaintenanceNew::getAuditMoney).collect(Collectors.joining(","));
                BigDecimal reduce = Arrays.stream(collect.split(",")).filter(StringUtils::isNotEmpty).filter(s -> !"null".equals(s)).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setEveryMoney(String.valueOf(reduce));
            }
        }
    }

    private Org getPrentId(String orgId) {
        Org org = (Org)this.orgManager.getById((Serializable)((Object)orgId));
        if (org != null) {
            return (Org)this.orgManager.getById((Serializable)((Object)org.getParentId()));
        }
        return null;
    }

    @Override
    public List<OrgMessageVo> getMessageCountVo() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<OrgMessageVo> lists = new ArrayList<OrgMessageVo>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = StatisticalStatementManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            OrgMessageVo fvo = new OrgMessageVo();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = StatisticalStatementManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            StatisticalStatementManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<OrgMessageVo> getChild(List<OrgMessageVo> allList, String pCode) {
        ArrayList<OrgMessageVo> returnList = new ArrayList<OrgMessageVo>();
        for (OrgMessageVo entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(StatisticalStatementManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private List<OrgMessageVo> setCount(List<OrgMessageVo> list) {
        Iterator<OrgMessageVo> it = list.iterator();
        while (it.hasNext()) {
            OrgMessageVo orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCountWorkOrder(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public OrgMessageVo newCountWorkOrder(List<String> roadList, OrgMessageVo orgVO) {
        BigDecimal decimalAll = new BigDecimal(2);
        QueryWrapper bridgeQueryWrapper = new QueryWrapper();
        bridgeQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", roadList);
        List bridgeList = this.bridgeInformationManager.list((Wrapper)bridgeQueryWrapper);
        orgVO.setBridgeCount(bridgeList.size());
        double bridgeSum = bridgeList.stream().mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal bridgeDecimal = new BigDecimal(bridgeSum);
        BigDecimal bridgeLinearMeter = bridgeDecimal.setScale(2, 4);
        BigDecimal bridgeSingleCount = bridgeLinearMeter.divide(decimalAll);
        orgVO.setBridgeLinearMeter(bridgeLinearMeter);
        orgVO.setBridgeSingleCount(bridgeSingleCount);
        long extraBigBridgeCount = bridgeList.stream().filter(s -> "1".equals(s.getType())).count();
        double extraBigBridgeLinearMeterSum = bridgeList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal extraBigBridgeLinearMeterBigDecimal = new BigDecimal(extraBigBridgeLinearMeterSum);
        BigDecimal extraBigBridgeLinearMeter = extraBigBridgeLinearMeterBigDecimal.setScale(2, 4);
        BigDecimal extraBigBridgeSingleCount = extraBigBridgeLinearMeter.divide(decimalAll);
        orgVO.setExtraBigBridgeCount(Integer.parseInt(String.valueOf(extraBigBridgeCount)));
        orgVO.setExtraBigBridgeLinearMeter(extraBigBridgeLinearMeter);
        orgVO.setExtraBigBridgeSingleCount(extraBigBridgeSingleCount);
        long bigBridgeCount = bridgeList.stream().filter(s -> "2".equals(s.getType())).count();
        double bigSum = bridgeList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal decimal = new BigDecimal(bigSum);
        BigDecimal bigBridgeLinearMeter = decimal.setScale(2, 4);
        BigDecimal bigBridgeSingleCount = bigBridgeLinearMeter.divide(decimalAll);
        orgVO.setBigBridgeCount(Integer.parseInt(String.valueOf(bigBridgeCount)));
        orgVO.setBigBridgeSingleCount(bigBridgeSingleCount);
        orgVO.setBigBridgeLinearMeter(bigBridgeLinearMeter);
        long middleBridgeCount = bridgeList.stream().filter(s -> "3".equals(s.getType())).count();
        double middleSum = bridgeList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal middleSumDecimal = new BigDecimal(middleSum);
        BigDecimal middleBridgeLinearMeter = middleSumDecimal.setScale(2, 4);
        BigDecimal middleBridgeSingleCount = middleBridgeLinearMeter.divide(decimalAll);
        orgVO.setMiddleBridgeCount(Integer.parseInt(String.valueOf(middleBridgeCount)));
        orgVO.setMiddleBridgeLinearMeter(middleBridgeLinearMeter);
        orgVO.setMiddleBridgeSingleCount(middleBridgeSingleCount);
        long smallBridgeCount = bridgeList.stream().filter(s -> "4".equals(s.getType())).count();
        double smallBridgeSum = bridgeList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(BridgeInformation::getLength).sum();
        BigDecimal smallBridgeBigDecimal = new BigDecimal(smallBridgeSum);
        BigDecimal smallBridgeLinearMeter = smallBridgeBigDecimal.setScale(2, 4);
        BigDecimal smallBridgeSingleCount = smallBridgeLinearMeter.divide(decimalAll);
        orgVO.setSmallBridgeCount(Integer.parseInt(String.valueOf(smallBridgeCount)));
        orgVO.setSmallBridgeLinearMeter(smallBridgeLinearMeter);
        orgVO.setSmallBridgeSingleCount(smallBridgeSingleCount);
        QueryWrapper tunnelQueryWrapper = new QueryWrapper();
        tunnelQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", roadList);
        List tunnelList = this.tunnelInformationManager.list((Wrapper)tunnelQueryWrapper);
        orgVO.setTunnelCount(Integer.parseInt(String.valueOf(tunnelList.size())));
        double tunnelSum = tunnelList.stream().mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal tunnelBigDecimal = new BigDecimal(tunnelSum);
        BigDecimal tunnelLinearMeter = tunnelBigDecimal.setScale(2, 4);
        BigDecimal tunnelSingleCount = tunnelLinearMeter.divide(decimalAll);
        orgVO.setTunnelSingleCount(tunnelSingleCount);
        orgVO.setTunnelLinearMeter(tunnelLinearMeter);
        long extraBigTunnelCount = tunnelList.stream().filter(s -> "1".equals(s.getType())).count();
        double extraBigSum = tunnelList.stream().filter(s -> "1".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal extraBigBigDecimal = new BigDecimal(extraBigSum);
        BigDecimal extraBigTunnelLinearMeter = extraBigBigDecimal.setScale(2, 4);
        BigDecimal extraBigTunnelSingleCount = extraBigTunnelLinearMeter.divide(decimalAll);
        orgVO.setExtraBigTunnelCount(Integer.parseInt(String.valueOf(extraBigTunnelCount)));
        orgVO.setExtraBigTunnelSingleCount(extraBigTunnelSingleCount);
        orgVO.setExtraBigTunnelLinearMeter(extraBigTunnelLinearMeter);
        long bigTunnelCount = tunnelList.stream().filter(s -> "2".equals(s.getType())).count();
        double bigTunnelSum = tunnelList.stream().filter(s -> "2".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal bigTunnelBigDecimal = new BigDecimal(bigTunnelSum);
        BigDecimal bigTunnelLinearMeter = bigTunnelBigDecimal.setScale(2, 4);
        BigDecimal bigTunnelSingleCount = bigTunnelLinearMeter.divide(decimalAll);
        orgVO.setBigTunnelCount(Integer.parseInt(String.valueOf(bigTunnelCount)));
        orgVO.setBigTunnelSingleCount(bigTunnelSingleCount);
        orgVO.setBigTunnelLinearMeter(bigTunnelLinearMeter);
        long middleTunnelCount = tunnelList.stream().filter(s -> "3".equals(s.getType())).count();
        double middleTunnelSum = tunnelList.stream().filter(s -> "3".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal middleTunnelBigDecimal = new BigDecimal(middleTunnelSum);
        BigDecimal middleTunnelLinearMeter = middleTunnelBigDecimal.setScale(2, 4);
        BigDecimal middleTunnelSingleCount = middleTunnelLinearMeter.divide(decimalAll);
        orgVO.setMiddleTunnelCount(Integer.parseInt(String.valueOf(middleTunnelCount)));
        orgVO.setMiddleTunnelSingleCount(middleTunnelSingleCount);
        orgVO.setMiddleTunnelLinearMeter(middleTunnelLinearMeter);
        long smallTunnelCount = tunnelList.stream().filter(s -> "4".equals(s.getType())).count();
        double smallTunnelCountSum = tunnelList.stream().filter(s -> "4".equals(s.getType())).mapToDouble(TunnelInformation::getLength).sum();
        BigDecimal smallTunnelCountBigDecimal = new BigDecimal(smallTunnelCountSum);
        BigDecimal smallTunnelCountLinearMeter = smallTunnelCountBigDecimal.setScale(2, 4);
        BigDecimal smallTunnelCountSingleCount = smallTunnelCountLinearMeter.divide(decimalAll);
        orgVO.setSmallTunnelCount(Integer.parseInt(String.valueOf(smallTunnelCount)));
        orgVO.setSmallTunnelSingleCount(smallTunnelCountSingleCount);
        orgVO.setSmallTunnelLinearMeter(smallTunnelCountLinearMeter);
        QueryWrapper culvertQueryWrapper = new QueryWrapper();
        culvertQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", roadList);
        List culvertInformationList = this.culvertInformationManager.list((Wrapper)culvertQueryWrapper);
        orgVO.setCulvertCount(culvertInformationList.size());
        QueryWrapper sideSlopeQueryWrapper = new QueryWrapper();
        sideSlopeQueryWrapper.in(roadList != null && roadList.size() > 0, (Object)"ROAD_SEGMENT_ID_", roadList);
        List slopeInformationList = this.sideSlopeInformationManager.list((Wrapper)sideSlopeQueryWrapper);
        orgVO.setSideSlopeCount(slopeInformationList.size());
        return orgVO;
    }
}

