/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.bidManagement.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.bidManagement.dao.BiddingManagementDao;
import com.artfess.cqxy.bidManagement.manager.BiddingManagementManager;
import com.artfess.cqxy.bidManagement.model.BiddingManagement;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BiddingManagementManagerImpl
extends BaseManagerImpl<BiddingManagementDao, BiddingManagement>
implements BiddingManagementManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private ProjectManagementManager pmm;

    public boolean saveOrUpdate(BiddingManagement entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eight.getCode());
            if (StringUtils.isBlank((CharSequence)ele.getGroup())) {
                ele.setGroup("BiddingManagement");
            }
            ele.setNode(ProjectStatusEnum.eight.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eight.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, BiddingManagement entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twelve.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twelve.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twelve.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twelve.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twelve.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twelve.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twelve.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twelve.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setSearchTitle(entity.getBidWinner() + "_" + entity.getBiddingAgency() + "_" + entity.getBiddingAgency() + "_" + entity.getFundsSource() + "_" + entity.getComplaintSituation() + "_" + entity.getBidWinnerAgentName() + "_" + entity.getBidWinnerAgentPhone() + "_" + entity.getImplementationPersonnelName() + "_" + entity.getImplementationPersonnelPhone() + "_" + entity.getRemarks() + "_" + entity.getActualPaymentMethod() + "_" + entity.getResponsibleUnit() + "_" + entity.getResponsiblePerson() + "_" + entity.getPayeePhone());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    private void handelEntity(BiddingManagement entity) {
        String code = this.scfs.getNextIdByAlias("ztbgl_zbbh");
        entity.setDocumentNumber(code.substring(StringUtils.lastOrdinalIndexOf((CharSequence)code, (CharSequence)"\"", (int)2) + 1, code.lastIndexOf("\"")));
    }

    @Override
    public BiddingManagement getById(String id) {
        BiddingManagement result = ((BiddingManagementDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<BiddingManagement> queryAllByPage(QueryFilter<BiddingManagement> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bbm", "pm");
        IPage<BiddingManagement> result = ((BiddingManagementDao)this.baseMapper).queryAllByPage((IPage<BiddingManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BiddingManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (BiddingManagement ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List biddingChargeType = this.sdm.queryDictListItemsByCode("zbfs");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, BiddingManagement.class, (ImportParams)new ImportParams());
            for (BiddingManagement ele : data) {
                ele.setProjectId(projectId);
                ele.setBiddingChargeType(BizUtils.getDicCodeByValue(biddingChargeType, ele.getBiddingChargeType()));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<BiddingManagement> queryFilter, HttpServletResponse response) throws IOException {
        List chargeType = this.sdm.queryDictListItemsByCode("zbfs");
        List complaints = this.sdm.queryDictListItemsByCode("zbgl-sfyts");
        List payType = this.sdm.queryDictListItemsByCode("zbgl-tbbzjzffs");
        List judgeMethod = this.sdm.queryDictListItemsByCode("zbgl-pbff");
        List isLegal = this.sdm.queryDictListItemsByCode("zbgl-sfwfwg");
        List hasComplaint = this.sdm.queryDictListItemsByCode("zbgl-ywts");
        List investmentProperties = this.sdm.queryDictListItemsByCode("zbgl-zbdwxz");
        String fileName = "\u62db\u6807\u4fe1\u606f-\u5bfc\u51fa\u7ed3\u679c";
        BizUtils.handleFilter(queryFilter, "bbm", "pm");
        List data = ((BiddingManagementDao)this.baseMapper).queryAllByPage((IPage<BiddingManagement>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BiddingManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (BiddingManagement ele : data) {
            ele.setBiddingChargeType(BizUtils.getDicValueByCode((List<DictModel>)chargeType, ele.getBiddingChargeType()));
            ele.setImplementationPersonnelPhone(BizUtils.getDicValueByCode((List<DictModel>)payType, ele.getImplementationPersonnelPhone()));
            ele.setImplementationPersonnelName(BizUtils.getDicValueByCode((List<DictModel>)judgeMethod, ele.getImplementationPersonnelName()));
            ele.setFundsSource(BizUtils.getDicValueByCode((List<DictModel>)isLegal, ele.getFundsSource()));
            ele.setHasComplaint(BizUtils.getDicValueByCode((List<DictModel>)hasComplaint, ele.getHasComplaint()));
            ele.setContractPaymentMethod(BizUtils.getDicValueByCode((List<DictModel>)investmentProperties, ele.getContractPaymentMethod()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BiddingManagement.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo) {
        List<Map<String, Object>> list = ((BiddingManagementDao)this.baseMapper).queryInvestment(statisticsVo);
        List chargeType = this.sdm.queryDictListItemsByCode("zbfs");
        if (null != list) {
            for (DictModel dic : chargeType) {
                String name = dic.getName();
                String value = dic.getValue();
                boolean isExistence = true;
                for (Map<String, Object> map : list) {
                    String type = map.get("type") == null ? "" : String.valueOf(map.get("type"));
                    if (!type.equalsIgnoreCase(value)) continue;
                    map.put("typeName", name);
                    isExistence = false;
                    break;
                }
                if (!isExistence) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", value);
                map.put("typeName", name);
                map.put("total", 0);
                list.add(map);
            }
        }
        return list;
    }
}

