/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.manager.DirectoryManagementManager;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u7ba1\u7406-\u76ee\u5f55\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/projectManagement/directoryManagement/v1"})
public class DirectoryManagementController
extends BaseController<DirectoryManagementManager, DirectoryManagement> {
    private static final Logger log = LoggerFactory.getLogger(DirectoryManagementController.class);

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e", httpMethod="POST")
    public CommonResult save(@ApiParam(name="dirObject", value="\u76ee\u5f55\u7ba1\u7406\u4fe1\u606f\u8868\u5bf9\u8c61") @RequestBody DirectoryManagement dirObject) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)dirObject);
        Assert.notNull((Object)((Object)dirObject), (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        boolean add = StringUtils.isEmpty((CharSequence)dirObject.getId());
        boolean save = add ? ((DirectoryManagementManager)this.baseService).save((Object)dirObject) : ((DirectoryManagementManager)this.baseService).updateById((Object)dirObject);
        ((DirectoryManagementManager)this.baseService).changeHasChildNode(dirObject, true);
        String msg = (add ? "\u6dfb\u52a0" : "\u4fee\u6539") + (save ? "\u6210\u529f" : "\u5931\u8d25");
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u4fdd\u5b58\u6216\u4fee\u6539\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(save, msg);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u5220\u9664\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((DirectoryManagementManager)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/updateSequence"})
    @ApiOperation(value="S-\u4fee\u6539\u9879\u76ee\u6392\u5e8f\u53f7", notes="\u524d\u7aef\u62d6\u52a8\u8bb0\u5f55\u8fdb\u884c\u6392\u5e8f\uff0c\u90a3\u4e48\u8981\u4f20\u5165\u53d1\u751f\u53d8\u52a8\u7684\u8bb0\u5f55\u7684ID\u53ca\u6392\u5e8f\u53f7\uff0c\u5982\"params\":{\"ID\u503c\":\"\u6392\u5e8f\u53f7\",\"ID\u503c\":\"\u6392\u5e8f\u53f7\"}", httpMethod="POST")
    public CommonResult sort(@ApiParam(name="params", value="\u53c2\u6570\u8bf4\u660e\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u4fee\u6539\u9879\u76ee\u6392\u5e8f\u53f7\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", params);
        ((DirectoryManagementManager)this.baseService).updateSequence(params);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<DirectoryManagement> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)id);
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        DirectoryManagement result = (DirectoryManagement)((Object)((DirectoryManagementManager)this.baseService).getById((Serializable)((Object)id)));
        boolean state = !BeanUtils.isEmpty((Object)((Object)result));
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/getByParentId"})
    @ApiOperation(value="S-\u6839\u636e\u7236\u8282\u70b9\u7f16\u7801\u67e5\u8be2\u5176\u5b50\u8282\u70b9", notes="\u6839\u636e\u7236\u8282\u70b9\u7f16\u7801\u67e5\u8be2\u5b50\u8282\u70b9\uff0cURL\u4f20\u53c2pCode\uff0c\u6839\u8282\u70b9\u4e3aroot", httpMethod="POST")
    public CommonResult<List<DirectoryManagement>> getByParentId(@RequestParam String pCode) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u83b7\u53d6\u6811\u72b6\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)pCode);
        List<DirectoryManagement> result = ((DirectoryManagementManager)this.baseService).getByParentId(pCode);
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u83b7\u53d6\u6811\u72b6\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/queryChildNodeByPage"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u5fc5\u987b\u4f20\u5165 PCODE_ \u7236\u8282\u70b9\u540d\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014bdm", httpMethod="POST")
    public CommonResult<PageList<DirectoryManagement>> queryChildNodeByPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<DirectoryManagement> queryFilter) {
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<DirectoryManagement> result = ((DirectoryManagementManager)this.baseService).queryChildNodeByPage(queryFilter);
        log.debug("\u76ee\u5f55\u7ba1\u7406-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }
}

