package com.artfess.cqxy.wps.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.cqxy.wps.model.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author 黎沐华
 * @date 2022/5/5 17:50
 */
@Slf4j
@RestController
@Api(tags = "WPS在线文档服务.用户回调接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/v1/3rd/user")
public class UserCallbackController {

    @ResponseBody
    @PostMapping("/info")
    @ApiOperation("用户信息")
    public Object userInfo() {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        User user = new User();
        user.setId("用户ID占位符");
        user.setName("用户名占位符");
        // TODO 用户权限
        user.setPermission("read");
        user.setAvatar_url("头像占位符");
        jsonArray.add(user);
        jsonObject.put("users", jsonArray);
        return jsonObject;
    }

}
