package com.artfess.cqxy.designEstimate.dao;

import com.artfess.cqxy.designEstimate.model.ConstructionDrawingDesign;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 设计概算 - 施工图设计表(BizConstructionDrawingDesign)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-02-15 18:13:17
 */
public interface ConstructionDrawingDesignDao extends BaseMapper<ConstructionDrawingDesign> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ConstructionDrawingDesign getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ConstructionDrawingDesign> queryAllByPage(IPage<ConstructionDrawingDesign> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ConstructionDrawingDesign> convert2Wrapper);

}

