package com.artfess.cqxy.projectManagement.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.model.ProjectStart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * (ProjectStart)表服务接口
 *
 * @author 黎沐华
 * @since 2022-06-01 16:47:14
 */
public interface ProjectStartManager extends BaseManager<ProjectStart> {


    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<ProjectStart> queryFilter, HttpServletResponse response) throws IOException;

    boolean deleteByIds(List<String> asList);

    ProjectStart getById(String id);

    PageList<ProjectStart> queryAllByPage(QueryFilter<ProjectStart> queryFilter);

}

