package com.artfess.cqxy.feasiblePlan.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.feasiblePlan.dao.PlanningSelectionSiteDao;
import com.artfess.cqxy.feasiblePlan.manager.PlanningSelectionSiteManager;
import com.artfess.cqxy.feasiblePlan.model.PlanningSelectionSite;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 规划许可-选址表(BizPlanningSelectionSite)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-02-15 09:32:24
 */
@Service
public class PlanningSelectionSiteManagerImpl extends BaseManagerImpl<PlanningSelectionSiteDao, PlanningSelectionSite> implements PlanningSelectionSiteManager {

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private BaseContext baseContext;

    @Autowired
    private ProjectManagementManager pmm;

    @Autowired
    private GlobalRetrievalManager grm;

    @Override
    public boolean saveOrUpdate(PlanningSelectionSite entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.four.getCode());
            ele.setGroup("PlanningSelectionSite");
            ele.setNode(ProjectStatusEnum.four.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        /// 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.four.getCode()));
        //更新项目项目建设地址
        ProjectManagement projectManagement = pmm.get(entity.getProjectId());
        if(null != projectManagement ){
            if(org.apache.commons.lang3.StringUtils.isNotBlank(entity.getProposedLocation())){
                projectManagement.setProjectAddress(entity.getProposedLocation());
            }
            if(org.apache.commons.lang3.StringUtils.isNotBlank(entity.getPrimaryCoverage())){
                projectManagement.setProjectContent(entity.getPrimaryCoverage());
            }
            pmm.updateById(projectManagement);

        }
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval,PlanningSelectionSite entity){
        ProjectManagement projectManagement = pmm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.five.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.five.getName());
        globalRetrieval.setBizTableName(FunctionEnum.five.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.five.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.five.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.five.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.five.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.five.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getEstablishmentName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setSearchTitle(entity.getEstablishmentName()+"_"+entity.getDocumentNumber()+"_"+entity.getEstablishmentApprovalUnit()+"_"+
                entity.getConstructionUnit()+"_"+entity.getConstructionProjectBasis()+"_"+entity.getProposedLocation()+"_"+
                entity.getEstablishmentScale()+"_"+entity.getPrimaryCoverage()+"_"+entity.getEstablishmentRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        grm.remove(new QueryWrapper<GlobalRetrieval>().in("FILE_SOURCE_ID_", ids));
//        for (String ele : ids) {
//            grm.remove(new QueryWrapper<GlobalRetrieval>().eq("FILE_SOURCE_ID_", ids));
//        }
        return removeByIds(ids);
    }

    @Override
    public PlanningSelectionSite getById(String id) {
        PlanningSelectionSite result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<PlanningSelectionSite> queryAllByPage(QueryFilter<PlanningSelectionSite> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpss", "pm");
        IPage<PlanningSelectionSite> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<PlanningSelectionSite> records = result.getRecords();
        for (PlanningSelectionSite ele : records) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull(projectId,"项目ID不能为空");
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<PlanningSelectionSite> data = ExcelImportUtil.importExcel(inputStream,PlanningSelectionSite.class,new ImportParams());
            for(PlanningSelectionSite ele:data){
                ele.setProjectId(projectId);
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<PlanningSelectionSite> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "规划许可-选址规划-导出结果";

        // 获取数据
        BizUtils.handleFilter(queryFilter, "bpss", "pm");
        List<PlanningSelectionSite> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0, -1, false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, DecisionBasis.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<PlanningSelectionSite> wrapper = new UpdateWrapper<PlanningSelectionSite>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }

}

