/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.ledger.manager.PayLedgerManager;
import com.artfess.cqxy.ledger.vo.PayLedgerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u53f0\u8d26-\u9879\u76ee\u652f\u4ed8\u53f0\u8d26\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/ledger/pay/v1"})
public class PayLedgerController {
    private static final Logger log = LoggerFactory.getLogger(PayLedgerController.class);
    @Autowired
    private PayLedgerManager manager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", httpMethod="POST")
    public CommonResult<PageList<PayLedgerVo>> page(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5668") @RequestBody QueryFilter<PayLedgerVo> queryFilter) {
        PageList<PayLedgerVo> result = this.manager.queryByPage(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="S-\u5bfc\u51fa\u6570\u636e\u5230Excel")
    public CommonResult exportDataToExcel(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5668") @RequestBody QueryFilter<PayLedgerVo> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("\u5bfc\u51fa\u6570\u636e\u5230Excel\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter, (Object)response);
        this.manager.exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/totalPayByYear"})
    @ApiOperation(value="S-\u5e74\u5ea6\u603b\u652f\u4ed8", notes="\u4f20\u5165\u5e74\u4efd year")
    public CommonResult totalPayByYear(@ApiParam(name="year", value="\u7edf\u8ba1\u5e74\u4efd") @RequestParam Integer year) {
        BigDecimal result = this.manager.totalPayByYear(year);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }
}

