/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.projectManagement.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectPersonnel;
import com.artfess.cqxy.projectManagement.vo.ProjectPersonnelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9879\u76ee\u7ba1\u7406-\u9879\u76ee\u4eba\u5458\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"/biz/projectManagement/projectPersonnel/v1"})
public class ProjectPersonnelController
extends BaseController<ProjectPersonnelManager, ProjectPersonnel> {
    private static final Logger log = LoggerFactory.getLogger(ProjectPersonnelController.class);

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u4fdd\u5b58\u6570\u636e", notes="\u7ea6\u5b9a\u53ef\u4ee5\u5c06\u591a\u4e2a\u4eba\u5458ID\u653e\u5230\u4e00\u4e2apersonnelId\u4e2d\uff0c\u4ee5\u82f1\u6587\u9017\u53f7\u9694\u5f00\uff0c\u540e\u7aef\u505a\u6279\u91cf\u65b0\u589e", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="dirObject", value="\u76ee\u5f55\u7ba1\u7406\u4fe1\u606f\u8868\u5bf9\u8c61") @RequestBody ProjectPersonnel perObject) {
        log.debug("\u9879\u76ee\u4eba\u5458-\u4fdd\u5b58\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)perObject);
        ProjectPersonnelManager s = (ProjectPersonnelManager)this.baseService;
        boolean result = ((ProjectPersonnelManager)this.baseService).batchSaveData(perObject);
        log.debug("\u9879\u76ee\u4eba\u5458-\u4fdd\u5b58\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(result, result ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25");
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u5220\u9664\u6570\u636e", httpMethod="POST")
    public CommonResult delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) {
        log.debug("\u9879\u76ee\u4eba\u5458-\u5220\u9664\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((ProjectPersonnelManager)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u9879\u76ee\u4eba\u5458-\u5220\u9664\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="S-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="POST")
    public CommonResult<ProjectPersonnelVo> selectOne(@ApiParam(name="id", value="\u4e3b\u952eID") @PathVariable String id) {
        log.debug("\u9879\u76ee\u4eba\u5458-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)id);
        Assert.notNull((Object)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ProjectPersonnelVo result = ((ProjectPersonnelManager)this.baseService).getVoById(id);
        boolean state = !BeanUtils.isEmpty((Object)result);
        log.debug("\u9879\u76ee\u4eba\u5458-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5 \u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(state, state ? "\u64cd\u4f5c\u6210\u529f" : "\u8be5ID\u6ca1\u6709\u5bf9\u5e94\u6570\u636e", (Object)result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u5728\u901a\u7528\u67e5\u8be2\u5668\u4e2d\u7684query\u5bf9\u8c61\u7ec4\u4f20\u5165\u67e5\u8be2\u53c2\u6570\uff0c\u5fc5\u987b\u4f20\u5165 projectId \u9879\u76eeID\uff0c\u6240\u6709\u53c2\u6570\u90fd\u9700\u8981\u5e26\u4e0a\u8868\u522b\u540d\u2014\u2014\u4e3b\u8868\u4e3app\u3001\u526f\u8868\u4e3auc", httpMethod="POST")
    public CommonResult<PageList<ProjectPersonnelVo>> selectAll(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<ProjectPersonnel> queryFilter) {
        log.debug("\u9879\u76ee\u4eba\u5458-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<ProjectPersonnelVo> result = ((ProjectPersonnelManager)this.baseService).queryAllByPage(queryFilter);
        log.debug("\u9879\u76ee\u4eba\u5458-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/getAllUsers"})
    @ApiOperation(value="S-\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4f9b\u6dfb\u52a0\u65f6\u9009\u62e9", httpMethod="POST")
    public CommonResult<List<ProjectPersonnelVo>> getAllUsers(String projectId) {
        log.debug("\u9879\u76ee\u4eba\u5458-\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb......");
        List<ProjectPersonnelVo> result = ((ProjectPersonnelManager)this.baseService).getAllUsers(projectId);
        log.debug("\u9879\u76ee\u4eba\u5458-\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }
}

