/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.contract.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.dao.AdministrativePaymentDao;
import com.artfess.cqxy.contract.manager.AdministrativePaymentManager;
import com.artfess.cqxy.contract.model.AdministrativePayment;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AdministrativePaymentManagerImpl
extends BaseManagerImpl<AdministrativePaymentDao, AdministrativePayment>
implements AdministrativePaymentManager {
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pmm;

    public PageList<AdministrativePayment> query(QueryFilter<AdministrativePayment> queryFilter) {
        PageList result = super.query(queryFilter);
        List records = result.getRows();
        for (AdministrativePayment ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return result;
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Transactional
    public boolean save(AdministrativePayment entity) {
        Assert.notNull((Object)((Object)entity), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)entity.getPaysDate(), (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        entity.setPaysYear(String.valueOf(entity.getPaysDate().getYear()));
        boolean main = super.save((Object)entity);
        boolean accessory = this.handleAccessory(entity);
        boolean sync = this.handleRetrieval(new GlobalRetrieval(), entity);
        return main && accessory && sync;
    }

    @Transactional
    public boolean updateById(AdministrativePayment entity) {
        Assert.notNull((Object)((Object)entity), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)entity.getPaysDate(), (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        entity.setPaysYear(String.valueOf(entity.getPaysDate().getYear()));
        boolean main = super.updateById((Object)entity);
        boolean accessory = this.handleAccessory(entity);
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        boolean sync = this.handleRetrieval(globalRetrieval, entity);
        return main && accessory && sync;
    }

    private boolean handleAccessory(AdministrativePayment entity) {
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("AdministrativePayment");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        return accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
    }

    private boolean handleRetrieval(GlobalRetrieval globalRetrieval, AdministrativePayment entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.thirtySix.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.thirtySix.getName());
        globalRetrieval.setBizTableName(FunctionEnum.thirtySix.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.thirtySix.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.thirtySix.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.thirtySix.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.thirtySix.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.thirtySix.getFunctionPath());
        globalRetrieval.setName(entity.getPaysName());
        globalRetrieval.setSearchTitle(entity.getPaysName() + "_" + entity.getPaysName() + "_" + entity.getRemarks());
        return this.grm.saveOrUpdate((Object)globalRetrieval);
    }
}

