package com.artfess.xqxt.meeting.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 参会人员变更记录
 *
 * @company 阿特菲斯信息技术有限公司
 * @author naf
 * @since 2023-05-17
 */
@ApiModel(value="BizMeetingEntrustLog对象", description="参会人员变更记录")
@Data
public class BizMeetingEntrustLog extends BaseModel<BizMeetingEntrustLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议id")
    @TableField("meeting_id_")
    private String meetingId;

    @ApiModelProperty(value = "最初参会人id")
    @TableField("root_user_")
    private String rootUser;

    @ApiModelProperty(value = "最初参会人")
    @TableField("root_user_name_")
    private String rootUserName;

    @ApiModelProperty(value = "委托人id")
    @TableField("entrust_user_")
    private String entrustUser;

    @ApiModelProperty(value = "委托人")
    @TableField("entrust_user_name_")
    private String entrustUserName;

    @ApiModelProperty(value = "委托参会人id")
    @TableField("entrust_meet_user_")
    private String entrustMeetUser;

    @ApiModelProperty(value = "委托参会人")
    @TableField("entrust_meet_user_name_")
    private String entrustMeetUserName;

    @ApiModelProperty(value = "变更次数")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "1同意，2拒绝，3取消")
    @TableField("state_")
    private Integer state;

    @ApiModelProperty(value = "委托原因")
    @TableField("entrust_reason_")
    private String entrustReason;


}
