package com.artfess.xqxt.meeting.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.EncryptUtil;
import com.artfess.xqxt.meeting.m900.bean.TerminalSimpleInfo;
import com.artfess.xqxt.meeting.m900.request.GetAddressBookRequest;
import com.artfess.xqxt.meeting.m900.request.LoginRequest;
import com.artfess.xqxt.meeting.m900.response.GetAddressBookResponse;
import com.artfess.xqxt.meeting.m900.response.LoginResponse;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.BizMeetingPlaceName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import com.artfess.xqxt.meeting.zteService.MultimediaConferenceServiceLocator;
import com.artfess.xqxt.meeting.zteService.MultimediaConferenceSoapBindingStub;
import com.artfess.xqxt.meeting.m900.bean.Participant;
import com.artfess.xqxt.meeting.m900.request.CreateConferenceRequest;
import com.artfess.xqxt.meeting.m900.response.CreateConferenceResponse;

import javax.annotation.Resource;
import javax.xml.namespace.QName;
import java.util.List;


@RestController
@Api(value = "中兴测试", tags = "中兴测试")
@RequestMapping("/api/test")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ZTEController {

    @Resource
    private ZTEManager zteManager;

    /**
     * 终端同步
     *
     * @return
     */
    @ApiOperation(value = "终端同步")
    @PostMapping("/synTer")
    public CommonResult synTer() throws Exception
    {
        if ("200".equals(zteManager.getAddresBook())){
            return new CommonResult
                    (true, "同步成功");
        }
        return new CommonResult
                (false, "同步失败");

    }

}
