/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.TenantIgnoreMenuManager;
import com.artfess.uc.model.TenantIgnoreMenu;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantIgnoreMenu/v1"})
@Api(tags={"\u79df\u6237\u7981\u7528\u83dc\u5355\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class TenantIgnoreMenuController
extends BaseController<TenantIgnoreMenuManager, TenantIgnoreMenu> {
    @Resource
    TenantIgnoreMenuManager tenantIgnoreMenuManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7981\u7528\u83dc\u5355\u5217\u8868")
    public PageList<TenantIgnoreMenu> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.tenantIgnoreMenuManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5")
    public TenantIgnoreMenu get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (TenantIgnoreMenu)this.tenantIgnoreMenuManager.get((Serializable)((Object)id));
    }

    @GetMapping(value={"/getIgnoreMenuCodes"})
    @ApiOperation(value="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e\u8be6\u60c5")
    public List<String> getIgnoreMenuCodes(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId) throws Exception {
        List<TenantIgnoreMenu> ignoreMenus = this.tenantIgnoreMenuManager.getByTenantId(tenantId);
        ArrayList<String> ignoreCodes = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(ignoreMenus)) {
            for (TenantIgnoreMenu menu : ignoreMenus) {
                ignoreCodes.add(menu.getMenuCode());
            }
        }
        return ignoreCodes;
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantIgnoreMenu", value="\u79df\u6237\u7981\u7528\u83dc\u5355\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantIgnoreMenu tenantIgnoreMenu) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u7981\u7528\u83dc\u5355\u6210\u529f";
        if (StringUtil.isEmpty((String)tenantIgnoreMenu.getId())) {
            this.tenantIgnoreMenuManager.create((Model)tenantIgnoreMenu);
        } else {
            this.tenantIgnoreMenuManager.update((Model)tenantIgnoreMenu);
            msg = "\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"saveByTenantId"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7981\u7528\u83dc\u5355\u6570\u636e")
    public CommonResult<String> saveByTenantId(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId, @ApiParam(name="ignoreMenus", value="\u9700\u8981\u7981\u7528\u7684\u83dc\u5355\u522b\u540d\u5217\u8868", required=true) @RequestBody List<String> ignoreMenus) throws Exception {
        return this.tenantIgnoreMenuManager.saveByTenantId(tenantId, ignoreMenus);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7981\u7528\u83dc\u5355\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7981\u7528\u83dc\u5355\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantIgnoreMenuManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

