/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.manager.UserGroupManager;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserGroup;
import com.artfess.uc.params.userGroup.UserGroupVo;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OrgUtil;
import com.artfess.uc.vo.UserAndGroupVo;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/userGroup/v1/"})
@Api(tags={"\u7fa4\u7ec4\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class UserGroupController
extends BaseController<UserGroupManager, UserGroup> {
    @Autowired
    UserGroupManager userGroupService;

    @RequestMapping(value={"userGroups/getUserGroupPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868")
    public PageList<UserGroup> getUserGroupPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter filter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin()) {
            filter.addFilter("creator", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
        }
        PageList list = this.userGroupService.query(filter);
        return list;
    }

    @RequestMapping(value={"userGroups/getUserGroupList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7fa4\u7ec4", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u7fa4\u7ec4")
    public List<UserGroup> getUserGroupList() throws Exception {
        return this.userGroupService.getAll();
    }

    @RequestMapping(value={"userGroup/addUserGroup"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7fa4\u7ec4", httpMethod="POST", notes="\u6dfb\u52a0\u7fa4\u7ec4")
    public CommonResult<String> addUserGroup(@ApiParam(name="userGroupVo", value="\u7fa4\u7ec4\u5bf9\u8c61", required=true) @RequestBody UserGroupVo userGroupVo) throws Exception {
        return this.userGroupService.addUserGroup(userGroupVo);
    }

    @RequestMapping(value={"userGroup/updateUserGroup"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7fa4\u7ec4", httpMethod="PUT", notes="\u66f4\u65b0\u7fa4\u7ec4")
    public CommonResult<String> updateUserGroup(@ApiParam(name="userGroupVo", value="\u7fa4\u7ec4\u5bf9\u8c61", required=true) @RequestBody UserGroupVo userGroupVo) throws Exception {
        return this.userGroupService.updateUserGroup(userGroupVo);
    }

    @RequestMapping(value={"userGroup/getUserGroup"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4")
    public UserGroup getUserGroup(@ApiParam(name="code", value="\u7fa4\u7ec4\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        return this.userGroupService.getByCode(code);
    }

    @RequestMapping(value={"userGroup/delUserGroup"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u7fa4\u7ec4", httpMethod="POST", notes="\u5220\u9664\u7fa4\u7ec4")
    public CommonResult<String> delUserGroup(@ApiParam(name="codes", value="\u7fa4\u7ec4\u4ee3\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        return this.userGroupService.delUserGroup(codes);
    }

    @RequestMapping(value={"userGroup/addGroupUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7fa4\u7ec4\u6dfb\u52a0\u7528\u6237\u7ec4", httpMethod="POST", notes="\u7fa4\u7ec4\u6dfb\u52a0\u7528\u6237\u7ec4\uff0cjson\u4e3a[{\"type\":\"user\",\"codes\":\"admin\"},...]\uff0c\u5176\u4e2dtype\u53ef\u586buser\u3001org\u3001pos\u3001role\u56db\u79cd\u7c7b\u578b\uff0c\u5206\u522b\u4ee3\u8868\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272\uff0ccodes\u4ee3\u8868\u5b83\u4eec\u7684\u4ee3\u7801\uff0c\u7528\u6237\u7684\u586b\u5199account\u4fe1\u606f\uff0c\u591a\u4e2a\u7528\u6237\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> addGroupUsers(@ApiParam(name="code", value="\u7fa4\u7ec4\u4ee3\u7801", required=true) @RequestParam String code, @ApiParam(name="json", value="\u7528\u6237\u7ec4\u4fe1\u606f", required=false) @RequestBody List<ObjectNode> json) throws Exception {
        return this.userGroupService.addGroupUsers(code, json);
    }

    @RequestMapping(value={"userGroup/getGroupUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4\u4e0b\u4eba\u5458\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4\u4e0b\u4eba\u5458\u4fe1\u606f")
    public List<User> getGroupUsers(@ApiParam(name="code", value="\u7fa4\u7ec4\u4ee3\u7801", required=true) @RequestParam String code) {
        return this.userGroupService.getGroupUsers(code);
    }

    @RequestMapping(value={"userGroup/getGroupUsersAndGroup"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4\u4e0b\u4eba\u5458\u4fe1\u606f+\u5206\u7ec4\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7fa4\u7ec4\u4e0b\u4eba\u5458\u4fe1\u606f")
    public List<UserAndGroupVo> getGroupUsersAndGroup(@ApiParam(name="code", value="\u7fa4\u7ec4\u4ee3\u7801", required=true) @RequestBody List<String> codes) {
        ArrayList<UserAndGroupVo> vos = new ArrayList<UserAndGroupVo>();
        for (String code : codes) {
            List<User> users = this.userGroupService.getGroupUsers(code);
            for (User groupUser : users) {
                UserAndGroupVo userVo = new UserAndGroupVo();
                BeanUtil.copyProperties((Object)groupUser, (Object)userVo, (String[])new String[0]);
                userVo.setGroupCode(code);
                vos.add(userVo);
            }
        }
        return vos;
    }

    @RequestMapping(value={"userGroup/deleteGroupPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u6570\u636e")
    public CommonResult<Integer> deleteGroupPhysical() throws Exception {
        Integer num = this.userGroupService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"userGroups/getUserGroupByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7fa4\u7ec4\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7fa4\u7ec4\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<UserGroup> getUserGroupByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        return this.userGroupService.getUserGroupByTime(btime, etime);
    }

    @RequestMapping(value={"userGroup/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7fa4\u7ec4\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7fa4\u7ec4\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7fa4\u7ec4\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        return this.userGroupService.isCodeExist(code);
    }

    @RequestMapping(value={"userGroup/updateGroupAuth"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7fa4\u7ec4\u7ba1\u7406\u5458", httpMethod="PUT", notes="\u66f4\u65b0\u7fa4\u7ec4\u7ba1\u7406\u5458")
    public CommonResult<String> updateGroupAuth(@ApiParam(name="code", value="\u7fa4\u7ec4\u7f16\u7801") @RequestParam(required=true) String code, @ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String account) throws Exception {
        return this.userGroupService.updateGroupAuth(code, account);
    }
}

