package com.artfess.workflow.bpmModel.plugin;

import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.service.RestfulService;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.artfess.bpm.plugin.task.restful.def.RestfulInvokePluginDef;

import javax.annotation.Resource;
import java.util.List;

/**
 * restful接口调用插件
 *
 * @author heyifan
 */
public class RestfulInvokePlugin extends AbstractBpmTaskPlugin {

    @Resource
    RestfulService restfulService;

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) {
        RestfulInvokePluginDef restfulPluginDef = (RestfulInvokePluginDef) pluginDef;
        List<Restful> restfuls = restfulPluginDef.getRestfulList();
        return BeanUtils.isNotEmpty(restfuls) ? restfulService.taskPluginExecute(pluginSession, pluginDef, restfuls) : null;
    }

}