package com.artfess.report.bigScreen.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.report.bigScreen.dao.BladeVisualCategoryDao;
import com.artfess.report.bigScreen.dao.BladeVisualDbDao;
import com.artfess.report.bigScreen.manager.BladeVisualDbManager;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.artfess.report.bigScreen.model.BladeVisualDb;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 可视化数据源配置表 服务实现类
 *
 * @company 阿特菲斯
 * @author 超级管理员
 * @since 2021-07-12
 */
@Service
public class BladeVisualDbManagerImpl extends BaseManagerImpl<BladeVisualDbDao, BladeVisualDb> implements BladeVisualDbManager {

    @Autowired
    BladeVisualDbDao bladeVisualDbDao;
    @Override
    public void updateBatchBladeVisualDb(String id) {
        UpdateWrapper<BladeVisualDb> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id),"id_",id);
        updateWrapper.set("is_dele_","1");
        bladeVisualDbDao.update(null,updateWrapper);
    }

    @Override
    public List<BladeVisualDb> queryBladeVisualDb(BladeVisualDb bladeVisualDb) {
        QueryWrapper<BladeVisualDb> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotBlank(bladeVisualDb.getId()), "id_", bladeVisualDb.getId());
        queryWrapper.like(StringUtils.isNotBlank(bladeVisualDb.getName()), "name_", bladeVisualDb.getName());
        queryWrapper.like(StringUtils.isNotBlank(bladeVisualDb.getDriverClass()), "driver_class_", bladeVisualDb.getDriverClass());
        return this.bladeVisualDbDao.selectList(queryWrapper);
    }
}
