package com.artfess.bpm.plugin.usercalc.matrix.content;

import java.io.IOException;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.plugin.core.context.AbstractUserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.usercalc.matrix.def.MatrixPluginDef;
import com.artfess.bpm.plugin.usercalc.matrix.runtime.MatrixPlugin;

/**
 * 角色矩阵作为流程审批人的上下文对象
 *
 * @company 广州宏天软件股份有限公司
 * @author pangq
 * @email pangq@jee-soft.cn
 * @date 2020年6月16日
 */
public class MatrixPluginContext extends AbstractUserCalcPluginContext {
	private static final long serialVersionUID = -5261531157333798291L;

	@Override
	public String getDescription() {
		MatrixPluginDef def = (MatrixPluginDef)this.getBpmPluginDef();
		if(def==null) return "";
		return def.getDescription();
	}

	@Override
	public String getTitle() {
		return "角色矩阵";
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class<? extends RunTimePlugin> getPluginClass() {
		return MatrixPlugin.class;
	}
	
	/**
	 * <matrix alias="" name="" />
	 */
	@Override
	public String getPluginXml() {
		BpmPluginDef bpmPluginDef = getBpmPluginDef();
		MatrixPluginDef def = (MatrixPluginDef)bpmPluginDef;
		if(def==null) return "";
		StringBuffer sb = new StringBuffer();
		sb.append("<matrix xmlns=\"http://www.jee-soft.cn/bpm/plugins/userCalc/matrix\" ");
		sb.append("  logicCal=\"" + def.getLogicCal().getKey() + "\" extract=\"" + def.getExtract().getKey()+ "\" code=\"" + def.getCode()
				+ "\" description=\"" + def.getDescription()+ "\" roleCode=\"" + def.getRoleCode()+ "\" roleName=\"" + def.getRoleName()+ "\" name=\"" + def.getName() + "\">");
		sb.append("<params>");
		sb.append("<![CDATA[");
		try {
			sb.append(BeanUtils.isNotEmpty(def.getParams())?JsonUtil.toJson(def.getParams()):"");
		} catch (IOException e) {
			e.printStackTrace();
		}
		sb.append("]]>");
		sb.append("</params>");
		
		sb.append("</matrix>");
		return sb.toString();
	}
	
	@Override
	protected BpmPluginDef parseElement(Element element) {
		MatrixPluginDef def = new MatrixPluginDef();
		String code = element.getAttribute("code");
		String name = element.getAttribute("name");
		String description = element.getAttribute("description");
		String roleCode = element.getAttribute("roleCode");
		String roleName = element.getAttribute("roleName");
		def.setCode(code);
		def.setName(name);
		def.setDescription(description);
		def.setRoleCode(roleCode);
		def.setRoleName(roleName);
		Element paramsEl= XmlUtil.getChildNodeByName(element, "params");
		if(paramsEl!=null){
			try {
				def.setParams(JsonUtil.toJsonNode(paramsEl.getTextContent()));
			} catch (DOMException | IOException e) {
				e.printStackTrace();
			}
		}
		return def;
	}

	@Override
	protected BpmPluginDef parseJson(ObjectNode pluginJson) throws Exception {
		MatrixPluginDef def = new MatrixPluginDef();
		String code = JsonUtil.getString(pluginJson, "code");
		String name = JsonUtil.getString(pluginJson, "name");
		String description = JsonUtil.getString(pluginJson, "description");
		String roleCode = JsonUtil.getString(pluginJson, "roleCode");
		String roleName = JsonUtil.getString(pluginJson, "roleName");
		def.setCode(code);
		def.setName(name);
		def.setDescription(description);
		def.setRoleCode(roleCode);
		def.setRoleName(roleName);
		if(JsonUtil.isContainsKey(pluginJson,"params")){
			def.setParams(pluginJson.get("params"));
		}
		return def;
	}
}
