package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.def.BpmBoDef;
import com.artfess.form.extmodel.ProcBoDef;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormMeta;
import com.artfess.form.persistence.dao.FormMetaDao;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.service.FormService;
import com.artfess.form.util.FormUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 表单元数据 处理实现类
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2020年4月14日
 */
@Service("bpmFormDefManager")
public class FormMetaManagerImpl extends BaseManagerImpl<FormMetaDao, FormMeta> implements FormMetaManager {
    private static Logger log = LoggerFactory.getLogger(FormMetaManagerImpl.class);
    public static final HashSet<String> noAttrFields = new HashSet<String>() {{
        add("button");
        add("text");
        add("immediate-single");
        add("immediate-textarea");
    }};
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormService formService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormMetaManager formMetaManager;

    /**
     * 创建实体包含子表实体
     */
    @Transactional
    public void create(FormMeta bpmFormDef) {
        super.create(bpmFormDef);
        try {
            this.createFields(bpmFormDef, null);
            updateBpmFormBo(bpmFormDef);
        } catch (IOException e) {
            throw new BaseException(e.getMessage(), e);
        }
    }

    @Override
    public void createFields(FormMeta bpmFormDef, Map<String, String> entIdMap) throws IOException {
        String formId = bpmFormDef.getId();
        List<BoDef> defList = boDefManager.getByFormId(bpmFormDef.getId());
        String expand = bpmFormDef.getExpand();
        if (BeanUtils.isEmpty(defList) && StringUtil.isNotEmpty(expand)) {
            JsonNode expandNode = JsonUtil.toJsonNode(expand);
            if (expandNode.has("boDefList")) {
                ArrayNode array = (ArrayNode) expandNode.get("boDefList");
                for (JsonNode defJson : array) {
                    BoDef bodef = boDefManager.getByDefId(defJson.get("id").asText());
                    if (BeanUtils.isNotEmpty(bodef)) {
                        defList.add(bodef);
                    }
                }
            }
        }
        if (BeanUtils.isNotEmpty(defList)) {
            for (BoDef boDef : defList) {
                String boDefId = boDef.getId();
                //处理主表字段
                BoEnt mainEnt = boDef.getBoEnt();
                List<BoAttribute> mainAttr = mainEnt.getBoAttrList();
                if (BeanUtils.isNotEmpty(mainAttr)) {
                    for (BoAttribute boAttribute : mainAttr) {
                        createFields(boAttribute, formId, boDefId);
                    }
                    //处理子表字段
                    List<BoEnt> subEnts = mainEnt.getChildEntList();
                    for (BoEnt subEnt : subEnts) {
                        List<BoAttribute> subAttr = subEnt.getBoAttrList();
                        for (BoAttribute subAttribute : subAttr) {
                            createFields(subAttribute, formId, boDefId);
                        }
                        //处理孙表字段
                        List<BoEnt> sunEnts = subEnt.getChildEntList();
                        for (BoEnt sunEnt : sunEnts) {
                            List<BoAttribute> sunAttr = sunEnt.getBoAttrList();
                            for (BoAttribute sunAttribute : sunAttr) {
                                createFields(sunAttribute, formId, boDefId);
                            }
                        }
                    }
                }
            }
        }
        try {//处理非bo字段但需要授权控件
            createPermissionFields(bpmFormDef);
        } catch (Exception e) {
            log.error("生成非bo字段到表form_field失败：" + e.getMessage());
        }

    }

    //处理非bo字段但需要授权控件
    public void createPermissionFields(FormMeta bpmFormDef) throws IOException {
        ArrayNode fields = FormUtil.resolutionFieldsByFormMeta(bpmFormDef);
        if (BeanUtils.isEmpty(fields)) {
            return;
        }
        for (int i = 0; i < fields.size(); i++) {
            JsonNode fieldObj = fields.get(i);
            String ctrlType = JsonUtil.getString(fieldObj, "ctrlType");
            if ("dataView".equals(ctrlType) && fieldObj.hasNonNull("templateObj")) {
                String boAttrId = JsonUtil.getString(fieldObj, "boAttrId");
                String columnType = JsonUtil.getString(fieldObj, "columnType");
                FormField formField = JsonUtil.toBean(fieldObj, FormField.class);
                if ("dataView".equals(ctrlType) && fieldObj.hasNonNull("templateObj")) {
                    JsonNode jsonNode = fieldObj.get("templateObj");
                    if (jsonNode.hasNonNull("boDefId")) {
                        formField.setBoDefId(jsonNode.get("boDefId").asText());
                    }
                }
                formField.setBoAttrId(boAttrId);
                formField.setCtrlType(ctrlType);
                formField.setType(columnType);
                formField.setId(UniqueIdUtil.getSuid());
                formField.setFormId(bpmFormDef.getId());
                formField.setSn(i);
                formFieldManager.create(formField);
            } else if (noAttrFields.contains(ctrlType) && fieldObj.hasNonNull("tableName") && fieldObj.hasNonNull("name")) {
                FormField formField = JsonUtil.toBean(fieldObj, FormField.class);
                formField.setCtrlType(ctrlType);
                formField.setId(UniqueIdUtil.getSuid());
                formField.setFormId(bpmFormDef.getId());
                formField.setSn(i);
                formFieldManager.create(formField);
            }
        }
    }

    private void createFields(BoAttribute boAttribute, String formId, String boDefId)
            throws JsonParseException, JsonMappingException, IOException {
        FormField formField = new FormField();
        formField.setId(UniqueIdUtil.getSuid());
        formField.setBoAttrId(boAttribute.getId());
        formField.setType(boAttribute.getDataType());
        formField.setFormId(formId);
        formField.setBoDefId(boDefId);
        formField.setName(boAttribute.getName());
        formField.setDesc(boAttribute.getDesc());
        formField.setSn(boAttribute.getSn());
        formField.setEntId(boAttribute.getEntId());
        formFieldManager.create(formField);
    }

//	private void createFields(JsonNode field, String bpmFormDefId, int sn,Map<String,String> entIdMap)
//			throws JsonParseException, JsonMappingException, IOException {
//		String boDefId = "";
//		ObjectNode fieldObj = (ObjectNode) field;
//		String type = JsonUtil.getString(fieldObj, "type");
//		boolean isMain = "main".equals(type);
//		if (isMain) {
//			boDefId = JsonUtil.getString(fieldObj, "boDefId");
//		}
//		String boAttrId = JsonUtil.getString(fieldObj, "boAttrId");
//		String ctrlType = JsonUtil.getString(fieldObj, "ctrlType");
//		String columnType = JsonUtil.getString(fieldObj, "columnType");
//		FormField formField = JsonUtil.toBean(fieldObj, FormField.class);
//		if(BeanUtils.isNotEmpty(entIdMap) && entIdMap.containsKey(formField.getEntId())){
//			formField.setEntId(entIdMap.get(formField.getEntId()));
//		}
//		if ("dataView".equals(ctrlType) && field.hasNonNull("templateObj")) {
//			JsonNode jsonNode = field.get("templateObj");
//			if (jsonNode.hasNonNull("boDefId")) {
//				formField.setBoDefId(jsonNode.get("boDefId").asText());
//			}
//		}
//		formField.setBoAttrId(boAttrId);
//		formField.setCtrlType(ctrlType);
//		formField.setType(columnType);
//		formField.setId(UniqueIdUtil.getSuid());
//		formField.setFormId(bpmFormDefId);
//		formField.setSn(sn);
//		formFieldManager.create(formField);
//	}

    /**
     * 更新表单和BO的关联记录
     *
     * @param formDef
     * @throws IOException
     */
    private void updateBpmFormBo(FormMeta formDef) throws IOException {
        String formId = formDef.getId();
        if (!StringUtil.isEmpty(formDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode(formDef.getExpand());
            JsonNode boDefs = expand.findValue("boDefList");
            List<String> boDef = formMetaManager.getBODefIdByFormId(formId);
            for (int i = 0; i < boDefs.size(); i++) {
                String boDefId = boDefs.get(i).path("id").textValue();
                if (BeanUtils.isNotEmpty(boDefId) && !boDef.contains(boDefId)) {
                    baseMapper.createBpmFormBo(UniqueIdUtil.getSuid(), boDefId, formId);
                }
            }
        }
    }

    @Override
    public List<FormMeta> getByBODefId(String BODefId) {
        return baseMapper.getByBODefId(BODefId);
    }

    @Override
    public FormMeta getByKey(String formKey) {
        return baseMapper.getByKey(formKey);
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Override
    @Transactional
    public void updateOpinionConf(String id, String opinionJson) {
        Map map = new HashMap();
        map.put("id", id);
        map.put("opinionJson", opinionJson);
        baseMapper.updateOpinionConf(map);
    }

    @Override
    public String getMetaKeyByFormKey(String formKey) {
        return baseMapper.getMetaKeyByFormKey(formKey);
    }

    @Override
    public List<String> getBOCodeByFormId(String formDefId) {
        return baseMapper.getBOCodeByFormId(formDefId);
    }

    /**
     * 删除记录包含子表记录
     */
    @Transactional
    public void remove(String entityId) {
        List<Form> forms = bpmFormManager.getByDefId(entityId);
        for (Form form : forms) {
            bpmFormManager.remove(form.getId());
        }

        baseMapper.deleteBpmFormBo(entityId);
        formFieldManager.delByMainId(entityId);
        super.remove(entityId);
    }

    /**
     * 更新实体同时更新子表记录
     */
    @Transactional
    public void update(FormMeta bpmFormDef) {
        super.update(bpmFormDef);
        String formDefId = bpmFormDef.getId();

        try {
            formFieldManager.delByMainId(formDefId);
            createFields(bpmFormDef, null);
            baseMapper.deleteBpmFormBo(formDefId);
            updateBpmFormBo(bpmFormDef);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<BoEnt> getChildrenByFormKey(String formKey) throws IOException {
        List<BoEnt> ents = new ArrayList<BoEnt>();
        FormMeta def = baseMapper.getByKey(formKey);
        if (BeanUtils.isNotEmpty(def)) {
            String expandStr = def.getExpand();
            if (StringUtil.isNotEmpty(expandStr)) {
                ObjectNode expandJson = (ObjectNode) JsonUtil.toJsonNode(expandStr);
                ArrayNode boDefList = (ArrayNode) JsonUtil.toJsonNode(expandJson.get("boDefList"));
                if (BeanUtils.isNotEmpty(boDefList)) {
                    for (JsonNode jsonNode : boDefList) {
                        BoDef byAlias = null;
                        if (jsonNode.has("alias")) {
                            byAlias = boDefManager.getByAlias(jsonNode.get("alias").asText());
                        }
                        if (BeanUtils.isEmpty(byAlias) && jsonNode.has("id")) {
                            byAlias = boDefManager.getByDefId(jsonNode.get("id").asText());
                        }
                        BoEnt boEnt = byAlias.getBoEnt();
                        if (BeanUtils.isNotEmpty(boEnt)) {
                            return boEnt.getChildEntList();
                        }

                    }
                }
            }
        }
        return ents;
    }

    @Override
    public List<BoData> getBoDataByFormDefId(String formDefId) {
        List<String> boCodes = baseMapper.getBOCodeByFormId(formDefId);
        List<BoData> boDatas = new ArrayList<BoData>();
        for (String code : boCodes) {
            BoData boData = formService.getBodataByDefCode("database", code);
            if (BeanUtils.isNotEmpty(boData)) {
                boDatas.add(boData);
            }
        }
        return boDatas;
    }

    @Override
    @Transactional
    public void deleteBpmFormBo(String formId) {
        baseMapper.deleteBpmFormBo(formId);
    }

    @Override
    @Transactional
    public void createBpmFormBo(String id, String boDefId, String formId) {
        List<String> boDef = formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isNotEmpty(boDefId) && !boDef.contains(boDefId)) {
            baseMapper.createBpmFormBo(id, boDefId, formId);
        }
    }

    @Override
    public List<String> getBODefIdByFormId(String formId) {
        return baseMapper.getBODefIdByFormId(formId);
    }

    @Override
    public List<FormMeta> getBODefByFormId(String formId) {
        return baseMapper.getBODefByFormId(formId);
    }

    @Override
    public FormMeta getFormDefByRev(Map<String, Object> map) {
        return baseMapper.getFormDefByRev(map);
    }

    @Override
    public PageList listJson(QueryFilter queryFilter) throws Exception {
        PageList<FormMeta> list = (PageList<FormMeta>) query(queryFilter);
        List<JsonNode> bpmFormDefList = new ArrayList<JsonNode>();
        for (FormMeta bpmFormdef : list.getRows()) {
            Map formJson = new HashMap();// JSONObject.fromObject(bpmForm);
            formJson.put("desc", bpmFormdef.getName());
            formJson.put("key", bpmFormdef.getKey());
            formJson.put("id", bpmFormdef.getId());
            formJson.put("name", bpmFormdef.getName());
            formJson.put("type", bpmFormdef.getType());
            // 计算bo对象
            String expand = bpmFormdef.getExpand();
            if (StringUtil.isNotEmpty(expand)) {
                JsonNode expandJson = JsonUtil.toJsonNode(expand);
                if (expandJson.get("boDefList") != null) {
                    formJson.put("boDefList", expandJson.get("boDefList").toString());
                }
            }
            bpmFormDefList.add(JsonUtil.toJsonNode(formJson));
        }
        PageList pageJson = new PageList(bpmFormDefList);
        pageJson.setPage(list.getPage());
        pageJson.setPageSize(list.getPageSize());
        pageJson.setRows(list.getRows());
        pageJson.setTotal(list.getTotal());
        return pageJson;
    }

    @Override
    public PageList listJsonByBODef(QueryFilter queryFilter, String defId, String formType, String topDefKey) throws Exception {
        List<ProcBoDef> boList = new ArrayList();
        // 如果是子流程，继承父类的bo数据。
        if (StringUtil.isNotEmpty(topDefKey)) {
            BpmBoDef bpmBodef = new BpmBoDef();
            /* BpmBoDef bpmBodef= BoDefUtil.getBpmBoDef(topDefKey); */
            boList = bpmBodef.getBoDefs();
        } else {
            // TODO
            /*
             * BpmProcessDef<BpmProcessDefExt> bpmProcessDef=
             * bpmDefinitionAccessor.getBpmProcessDef(defId); DefaultBpmProcessDefExt
             * defExt= (DefaultBpmProcessDefExt) bpmProcessDef.getProcessDefExt(); boList=
             * defExt.getBoDefList();
             */
        }
        if (boList.size() == 0) {
            return new PageList();
        }
        List<String> codes = new ArrayList<String>();
        for (ProcBoDef procBoDef : boList) {
            codes.add(procBoDef.getKey());
        }
        List<Form> list = bpmFormManager.getByBoCodes(codes, formType, queryFilter);

        return new PageList(list);
    }

    @Override
    public Map getChooseDesignTemplate(String subject, String categoryId, String formDesc, Boolean isSimple) throws Exception {
        Map mv = new HashMap();

        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readByClassPath(templatePath + "designtemps.xml");
        Document document = Dom4jUtil.loadXml(xml);
        Element root = document.getRootElement();
        List<Element> list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!reStr.equals("["))
                reStr += ",";
            reStr += "{name:'" + name + "',alias:'" + alias + "',templateDesc:'" + templateDesc + "'}";
        }
        reStr += "]";

        mv.put("subject", subject);
        mv.put("categoryId", categoryId);
        mv.put("formDesc", formDesc);
        mv.put("temps", reStr);
        mv.put("isSimple", isSimple);
        return mv;
    }

    @Override
    public void createByImport(FormMeta formDef, Map<String, String> entIdMap) {
        super.create(formDef);
        try {
            this.createFields(formDef, entIdMap);
            updateBpmFormBo(formDef);
        } catch (IOException e) {
            throw new BaseException(e.getMessage(), e);
        }
    }

    @Override
    public void updateByImport(FormMeta formDef, Map<String, String> entIdMap) {
        super.update(formDef);
        String formDefId = formDef.getId();

        try {
            formFieldManager.delByMainId(formDefId);
            createFields(formDef, entIdMap);
            baseMapper.deleteBpmFormBo(formDefId);
            updateBpmFormBo(formDef);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Map<String, Object>> getBoBindFormsByFormKey(String formKey) {
        return baseMapper.getBoBindFormsByFormKey(formKey);
    }

}
