package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.form.model.OperationButtonEntity;
import com.artfess.form.persistence.dao.OperationButtonDao;
import com.artfess.form.persistence.manager.OperationButtonManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 业务列表模型  --- 功能操作按钮配置表 服务实现类
 * </p>
 *
 * @author wh
 * @since 2020-05-19
 */
@Service
public class OperationButtonServiceImpl extends BaseManagerImpl<OperationButtonDao, OperationButtonEntity> implements OperationButtonManager {
    @Autowired
    private OperationButtonManager mapper;

    @Override
    public List<OperationButtonEntity> queryModuleButton(String buttonName, Integer isTemp) {
        QueryWrapper<OperationButtonEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.like(StringUtils.isNotEmpty(buttonName),"name", buttonName);
        return mapper.list(queryWrapper);
    }

    @Override
    @Transactional
    public void deleteModuleButton(List<String> ids) {
        Assert.notEmpty(ids,"ids不能为空");
        this.mapper.deleteModuleButton(ids);
    }

    @Override
    @Transactional
    public void updateModuleButtonSequence(HashMap<String, Integer> map) {
        //this.updateEntitySequence(map);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void updateButtonStatus(String ids, Integer status) {
        if(StringUtils.isNotBlank(ids)) {
            // 1.修改启用状态
            List<String> idList = Arrays.asList(ids.split(","));
            //this.updateEntityFlags(idList,status);
        }
    }

    public Integer queryNextSequence(){
        return this.getNextSequence(null);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public OperationButtonEntity saveModuleButton(OperationButtonEntity button){
        QueryWrapper<OperationButtonEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("code", button.getCode());
        queryWrapper.ne(StringUtils.isNotEmpty(button.getId()),"id", button.getId());
        int  count=mapper.count(queryWrapper);
        if(count>0){
            throw new ApplicationException("编码不能重复");
        }
        this.saveOrUpdate(button);
        return button;
    }

}