package com.artfess.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Value;

import java.time.LocalDateTime;

/**
 * @author zhx
 * @create 2021/7/29
 */
public abstract class BizModel <T extends BizModel<?>> extends AutoFillModel<T> {

//    @JsonIgnore
    @ApiModelProperty(value = "创建人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="CREATE_ORG_NAME_", fill= FieldFill.INSERT, select=false)
    private String createOrgName;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="CREATE_COMPANY_ID_", fill= FieldFill.INSERT, select=false)
    private String createCompanyId;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="CREATE_COMPANY_NAME_", fill= FieldFill.INSERT, select=false)
    private String createCompanyName;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="CREATE_NAME_", fill= FieldFill.INSERT, select=false)
    private String createName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="UPDATE_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人组织ID")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="UPDATE_ORG_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgId;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="UPDATE_ORG_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="UPDATE_COMPANY_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateCompanyId;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="UPDATE_COMPANY_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateCompanyName;

//    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_EMPTY,value="LAST_TIME_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    @TableLogic
    @Value("0")
    private String isDele;

    @JsonIgnore
    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }

    public String getCreateCompanyId() {
        return createCompanyId;
    }

    public void setCreateCompanyId(String createCompanyId) {
        this.createCompanyId = createCompanyId;
    }

    public String getCreateCompanyName() {
        return createCompanyName;
    }

    public void setCreateCompanyName(String createCompanyName) {
        this.createCompanyName = createCompanyName;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public String getUpdateCompanyName() {
        return updateCompanyName;
    }

    public void setUpdateCompanyName(String updateCompanyName) {
        this.updateCompanyName = updateCompanyName;
    }

    public String getUpdateCompanyId() {
        return updateCompanyId;
    }

    public void setUpdateCompanyId(String updateCompanyId) {
        this.updateCompanyId = updateCompanyId;
    }

    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }

    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }

    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "BizModel{" +
                "createOrgName='" + createOrgName + '\'' +
                ", createCompanyId='" + createCompanyId + '\'' +
                ", createCompanyName='" + createCompanyName + '\'' +
                ", createName='" + createName + '\'' +
                ", updateName='" + updateName + '\'' +
                ", updateCompanyName='" + updateCompanyName + '\'' +
                ", updateCompanyId='" + updateCompanyId + '\'' +
                ", updateOrgId='" + updateOrgId + '\'' +
                ", updateOrgName='" + updateOrgName + '\'' +
                ", lastTime=" + lastTime +
                ", isDele='" + isDele + '\'' +
                ", version=" + version +
                '}';
    }
}
