package com.artfess.xqxt.meeting.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@TableName("biz_meeting_place")
public class MeetingPlace extends Model<MeetingPlace> {
    @ApiModelProperty("主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("会议ID")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty("会议室ID")
    @TableField("PLACE_ID_")
    private String placeId;

    @ApiModelProperty("会议室名称")
    @TableField("PLACE_NAME")
    private String placeName;

    @ApiModelProperty(value = "终端名称")
    @TableField(exist = false)
    private String terminalName;

    @ApiModelProperty(value = "终端号码")
    @TableField(exist = false)
    private String terminalNumber;


    @ApiModelProperty(value = "0x00：H323 终端 0x01：E1 普通终端 0x02：E1 高清终端 0x03: SIP 终端 0x04：zte_sip 终端 0x05：4E1 双模 0x06: 323+tip 网真终端0x07：sip+tip 网真终端")
    @TableField(exist = false)
    private int terType;

    @ApiModelProperty(value = "0:呼叫号码 1:呼叫 IP 地址")
    @TableField(exist = false)
    private int callMode;

    @ApiModelProperty(value = "呼叫 IP 地址")
    @TableField(exist = false)
    private String ipAddress;

    @ApiModelProperty(value = "终端id")
    @TableField(exist = false)
    private String terminalId;

}
