package com.artfess.xqxt.meeting.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@TableName("biz_meeting_user")
public class MeetingUser extends Model<MeetingUser> {

    @ApiModelProperty("主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("会议ID")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty("人员ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty("人员姓名")
    @TableField("USER_NAME")
    private String userName;

    @ApiModelProperty("用户分组")
    @TableField("USER_GROUP")
    private String userGroup;

    @ApiModelProperty("人员账号")
    @TableField(exist = false)
    private String account;

    @ApiModelProperty("人员所属部门ID")
    @TableField(exist = false)
    private String deptId;

    @ApiModelProperty("人员所属部门名称")
    @TableField(exist = false)
    private String deptName;

    @ApiModelProperty("签到状态0：已签到，1：未签到，点击管理会议或者进入会议时直接自动签到")
    @TableField("SIGN_IN_STATUS_")
    private Integer signInStatus;

    @TableField("SIGN_OUT_STATUS_")
    @ApiModelProperty("签退状态0：已签退，1：未签退如果当前用户已签到并且自己没有手动签退系统需要就在会议结束时自动为其签退")
    private Integer signOutStatus;

    @TableField("SIGN_IN_TYPE_")
    @ApiModelProperty("签退类型1：用户手动签退，2：会议结束系统自动签退")
    private Integer signInType;

    @TableField("FIRST_MEMBERSHIP_DATE_")
    @ApiModelProperty("首次入会时间点击管理会议或者进入会议时直接自动签到")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime firstMembershipDate;

    @TableField("LAST_EXIT_DATE_")
    @ApiModelProperty("最后退出时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastExitDate;

    @ApiModelProperty("反馈状态，0：已反馈，1：未反馈，默认为1")
    @TableField("FEED_BACK_STATUS_")
    private String feedBackStatus;

    @ApiModelProperty("反馈结果，1：准时参加会议，2：推迟参加会议，3：不能参加会议 4 委托他人参会")
    @TableField("FEED_BACK_")
    private String feedBack;

    @ApiModelProperty("反馈时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("FEED_BACK_DATE")
    private LocalDateTime feedBackDate;

    @ApiModelProperty("预计入会时间")
    @TableField("ESTIMATED_ARRIVAL_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime estimatedArrivalDate;

    @ApiModelProperty("预计晚到时间，单位：分钟，当反馈结果为推迟参加会议时填写")
    @TableField("ESTIMATED_ARRIVAL_TIME_")
    private Long estimatedArrivalTime;

    @TableField("NOT_JOINING_REASONS_")
    @ApiModelProperty("未入会原因，当反馈结果不为准时参加会议时填写")
    private String notJoiningReasons;


    @TableField("IS_ENTRUST_")
    @ApiModelProperty("是否由他人委托")
    private Integer isEntrust;

    @ApiModelProperty("文件列表")
    @TableField(exist = false)
    List<BizMeetingAccessory> fileList;

    @ApiModelProperty("图片列表")
    @TableField(exist = false)
    List<BizMeetingAccessory> imageList;

    @ApiModelProperty("附件列表")
    @TableField(exist = false)
    List<BizMeetingAccessory> meetingAccessoryList;

}
