package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * 会议表（参考企业微信预约会议）
 */
@Data
@TableName("biz_meeting")
@ApiOperation(value = "会议实体类")
public class Meeting extends BizModel<Meeting> {
    @ApiModelProperty("主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("会议主题")
    @TableField("THEME_")
    private String theme;

    @TableField("REMARK_")
    @ApiModelProperty("备注")
    private String remark;

    @TableField("START_TIME_")
    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    @TableField("END_TIME_")
    @JsonFormat(pattern = "MM-dd HH:mm")
    private LocalDateTime endTime;

    @ApiModelProperty("提醒人员类别")
    @TableField("REMIND_USER_")
    private Integer remindUser;

    @ApiModelProperty("主持人")
    @TableField("HOST_")
    private String host;

    @TableField("PASSWORD_")
    @ApiModelProperty("开会密码")
    private String password;

    @ApiModelProperty("是否开启等候室（0是1否）")
    @TableField("IS_WAIT_ROOM_")
    private Integer isWaitRoom;

    @ApiModelProperty("是否允许成员在主持人进会前加入（0是1否）")
    @TableField("IS_OPEN_")
    private Integer isOpen;

    @ApiModelProperty("提醒时间类别")
    @TableField("REMIND_TIME_")
    private String remindTime;

    @ApiModelProperty("静音类别")
    @TableField("MUTE_")
    private Integer mute;

    @ApiModelProperty("入会成员限制")
    @TableField("LIMIT_USER_")
    private Integer limitUser;

    @ApiModelProperty("是否开启水印（0是1否）")
    @TableField("IS_WATERMARK_")
    private Integer isWatermark;

    @ApiModelProperty("会议类型，1：现场会议，2：视频会议")
    @TableField("MEETING_TYPE_")
    private Integer meetingType;

    @ApiModelProperty("会议状态，1：未开始，2：进行中，3：已结束，4：取消")
    @TableField("MEETING_STATUS_")
    private Integer meetingStatus;

    @ApiModelProperty("是否已发送消息通知,0：已发送 1：未发送")
    @TableField("IS_SEND_")
    private Integer isSend;

    @ApiModelProperty("创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty("创建姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty("会议内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty("会议轮训状态(0：轮训开启，1：轮训关闭)")
    @TableField("ROTATION_STATUS_")
    private Integer rotationStatus;


    @ApiModelProperty("会议编号")
    @TableField("CONFERENCE_NUMBER_")
    private String conferenceNumber;

    @ApiModelProperty("支持录播，true：支持，false：不支持")
    @TableField("IF_RECORD_")
    private Boolean ifRecord;

    @ApiModelProperty("录制状态，Recording 录制中 Pause 暂停")
    @TableField("RECORD_STATE_")
    private String recordState;

    @ApiModelProperty("是否处于锁定状态， true 锁定 false 非锁定")
    @TableField("LOCK_STATE_")
    private Boolean lockState;

    @ApiModelProperty("会议控制模式， chairman ：主席控制，director：导演控制， vas：声控")
    @TableField("CONFCTRL_MODE_")
    private String confCtrlMode;

    @ApiModelProperty("广播源会场 ID")
    @TableField("BOARDCASTER_")
    private String boardcaster;

    @ApiModelProperty("辅视频源会场 ID")
    @TableField("DUAL_BOARDCASTER_")
    private String dualBoardcaster;

    @ApiModelProperty("主席会场 ID")
    @TableField("CHAIRMAN_")
    private String chairman;

    @ApiModelProperty("是否 UP 模式 up：UP 会议 normal：普通会议")
    @TableField("IF_UP_MODE_")
    private String ifUpMode;

    @ApiModelProperty("会议多画面模式： auto:自动控制多画面 manual:手动控制")
    @TableField("MULTI_PICCTRL_MODE_")
    private String multiPicCtrlMode;

    @ApiModelProperty("最大画面数 1~25")
    @TableField("MAX_PIC_NUM_")
    private Integer maxPicNum;

    @ApiModelProperty("当前画面数")
    @TableField("CUR_PIC_NUM_")
    private Integer curPicNum;


}
