package com.artfess.xqxt.meeting.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.entity.BizNoModel;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 会议投票主题表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-11-03
 */
@Data
@TableName("biz_meeting_topic")
@ApiModel(value="BizMeetingTopic对象", description="会议投票主题表")
public class BizMeetingTopic extends BizNoModel<BizMeetingTopic> {

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议id")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty(value = "投票主题")
    @TableField("TOPIC_CONTENT_")
    private String topicContent;

    @ApiModelProperty(value = "补充描述")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否匿名投票(0：是，1：否)")
    @TableField("ANONYMOUS_")
    private String anonymous;

    @ApiModelProperty(value = "状态")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty("问题列表")
    @TableField(exist = false)
    private List<BizMeetingQuestion> questionList;

    @ApiModelProperty("会议主题")
    @TableField(exist = false)
    private String mettingTheme;

    @ApiModelProperty("投票人")
    @TableField(exist = false)
    private String userIds;

    @ApiModelProperty("投票人列表")
    @TableField(exist = false)
    private List<User> users;



    @ApiModelProperty("投票人员总数")
    @TableField(exist = false)
    private Integer votedTotalNum;
}
