package com.artfess.xqxt.meeting.manager;


import com.artfess.base.model.CommonResult;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.request.*;
import com.artfess.xqxt.meeting.m900.response.*;
import com.artfess.xqxt.meeting.m900.bean.*;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.HistoryConferenceVO;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

public interface ZTEManager {

    //获取token
    String getToken();


    //获取地址薄
    String getAddresBook();


    //获取终端
    void getTerList();

    //发起视频会议
    CreateConferenceResponse sendMeeting(MeetingDTO dto);

    //修改视频会议状态
    GetConferenceStatusResponse updateMeeting(String id);

    //取消会议
    String endMeeting(String id);

    //会场静音
    String quiet(String id, String terId, boolean isSleep);

    //取消会场静音
    String cancelQuiet(String id, String terId, boolean isSleep);

    //会场呼叫
    String connect(String id, String[] terIds, boolean isSleep);

    //会场断开
    String disconnect(String id, String[] terIds);

    //会议终端状态
    ParticipantStatusV2[] participantStatusV2(String id);

    //添加终端
    String inviteParticipant(String id,Participant participant);

    /**
     * 设置主席
     * @param id 会议ID
     * @param placeId 终端ID
     */
    String setChairman(String id, String placeId);

    /**
     * 广播会场
     * @param id 会议ID
     * @param placeId 终端ID
     */
    String boardcastParticipant(String id, String placeId);

    /**
     * 开始/停止轮训
     * @param id 会议ID
     * @param terminalIdentifier 终端ID列表，多个使用逗号分割
     * @param cmdType 命令类型，0：停止轮训，1：开始轮训
     * @return
     */
    String browseParticipant(String id, String terminalIdentifier, Integer cmdType);


    /**
     * 获取指定会议指定会场状态，如果不传会场则查询会议下所有会场状态
     * @param meetingId 会议ID
     * @param terminalIdentifiers 终端ID数组
     * @return
     */
    List<BizSiteParamExVO> getParticipantStatusV2(String meetingId, String[] terminalIdentifiers) throws Exception;

    /**
     * 根据会议ID查询会议最新状态
     * @param meetintId
     * @return
     */
    MeetingVO getConferenceStatus(String meetintId) throws Exception;


    /**
     * 根据会议ID查询会议最新状态
     * @param meetingVO
     * @return
     */
    MeetingVO getConferenceStatus(MeetingVO meetingVO) throws Exception;


    /**
     * 会场哑音，关闭指定会场麦克输入，如果不传终端ID则所有终端关闭
     * @param id 会议id
     * @param terId 终端ID
     * @return 状态码
     */
    String muteParticipant(String id, String terId, boolean isSleep);

    /**
     * 取消会场哑音，打开指定会场麦克输入，如果不传终端ID则所有终端打开
     * @param id 会议ID
     * @param terId 终端ID
     * @return 状态码
     */
    String cancelMuteParticipant(String id, String terId, boolean isSleep);


    /**
     * 取消已经预约的会议
     * @param meetingId 会议ID
     * @return
     */
    String cancelConferenceReserved(String meetingId);


    /**
     * 删除会场
     * @param id 会议ID
     * @param placeId 删除的会场终端ID
     * @return
     */
    String deleteParticipant(String id, String placeId);


    /**
     * 获取中兴正在进行的会议列表
     * @return
     */
    List<ConferenceStatus> getConferenceInfoList();

    /**
     * 获取中兴预约会议列表
     * @return
     */
    List<ConferenceSimpleInfo> getConferenceReservedList();

    /**
     * 获取会议终端列表
     * @param conferenceIdentifier 会议ID
     * @param page 页号，如果为-1，则表示不进行分页查询，查询所有的
     * @param numPerPage 每页显示多少条记录，如果为-1，则表示不进行分页查询，查询所有
     * 的
     * @return
     */
    List<ConfNode> getConfNodeList(String conferenceIdentifier, int page, int numPerPage);

    /**
     * 查询中兴历史会议
     * @param historyConferenceVO
     * @return
     */
    List<ConferenceStatus> getHistoryConferenceList(HistoryConferenceVO historyConferenceVO);


    /**
     * 延长会议时间
     * @param meetingId 会议id
     * @param minutes 延长时间
     * @return
     */
    ProlongConferenceResponse prolongConference(String meetingId, int minutes);

}
