package com.artfess.xqxt.meeting.dto;

import com.artfess.xqxt.meeting.model.BizMeetingTopic;

import com.artfess.xqxt.meeting.model.MeetingPlace;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import java.time.LocalDateTime;
import java.util.List;

@Data
public class MeetingDTO {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("会议编号")
    private String conferenceNumber;


    @ApiModelProperty("会议主题")
    private String theme;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("开始时间")

    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")

    private LocalDateTime endTime;

    @ApiModelProperty("提醒人员类别")
    private Integer remindUser;

    @ApiModelProperty("主持人")
    private String host;

    @ApiModelProperty("开会密码")
    private String password;

    @ApiModelProperty("是否开启等候室（0是1否）")
    private Integer isWaitRoom;

    @ApiModelProperty("是否允许成员在主持人进会前加入（0是1否）")
    private Integer isOpen;

    @ApiModelProperty("提醒时间类别")
    private String remindTime;

    @ApiModelProperty("静音类别")
    private Integer mute;

    @ApiModelProperty("入会成员限制")
    private Integer limitUser;

    @ApiModelProperty("是否开启水印（0是1否）")
    private Integer isWatermark;

    @ApiModelProperty("会议类型")
    private Integer meetingType;

    @ApiModelProperty("会议状态")
    private Integer meetingStatus;

    @ApiModelProperty("创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty("创建姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty("是否已发送消息通知")
    @TableField("IS_SEND_")
    private Integer isSend;

    @ApiModelProperty("会议内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty("会议轮训状态")
    @TableField("ROTATION_STATUS_")
    private Integer rotationStatus;


    @ApiModelProperty("参会分组编码")
    private List<String> userCodes;


    @ApiModelProperty("参会人")
    private List<MeetingUser> users;


    @ApiModelProperty("会议室")
    private List<MeetingPlace> places;

    @ApiModelProperty("文件信息")
    private String files;

    @ApiModelProperty("投票信息")
    private List<BizMeetingTopic> topics;


}
