/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.attachment;

import com.artfess.base.annotation.BigDecimalFormat;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

public final class BigDecimalFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<BigDecimalFormat> {
    public Set<Class<?>> getFieldTypes() {
        HashSet types = new HashSet();
        types.add(Integer.class);
        return types;
    }

    public Printer<BigDecimal> getPrinter(BigDecimalFormat annotation, Class<?> fieldType) {
        return new BigDecimalFormatter();
    }

    public Parser<BigDecimal> getParser(BigDecimalFormat annotation, Class<?> fieldType) {
        return new BigDecimalFormatter();
    }

    private class BigDecimalFormatter
    implements Formatter<BigDecimal> {
        private BigDecimalFormatter() {
        }

        public String print(BigDecimal object, Locale locale) {
            if (object == null) {
                return null;
            }
            return object.stripTrailingZeros().toPlainString();
        }

        public BigDecimal parse(String object, Locale locale) {
            if (object == null) {
                return null;
            }
            return new BigDecimal(object).stripTrailingZeros();
        }
    }
}

